import _extends from "@babel/runtime/helpers/extends";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }
/** @jsx jsx */
import { jsx, css } from '@emotion/react';
import { components } from 'react-select';
import Spinner from '@atlaskit/spinner';
import SelectClearIcon from '@atlaskit/icon/glyph/select-clear';
import DownIcon from '@atlaskit/icon/glyph/chevron-down';
var iconContainerStyles = css({
  all: 'unset',
  outline: 'revert',
  display: 'flex',
  alignItems: 'center'
});
export var ClearIndicator = function ClearIndicator(props) {
  return jsx(components.ClearIndicator, _objectSpread(_objectSpread({}, props), {}, {
    innerProps: _objectSpread(_objectSpread({}, props.innerProps), {}, {
      'aria-hidden': 'false'
    })
  }), jsx("button", {
    css: iconContainerStyles,
    type: "button",
    tabIndex: -1
  }, jsx(SelectClearIcon, {
    size: "small",
    label: "clear"
  })));
};
export var DropdownIndicator = function DropdownIndicator(props) {
  return jsx(components.DropdownIndicator, props, jsx(DownIcon, {
    label: "open"
  }));
};
export var LoadingIndicator = function LoadingIndicator(props) {
  var loadingCSS = css(props.getStyles('loadingIndicator', props));
  return jsx("div", _extends({
    css: loadingCSS
  }, props.innerProps), jsx(Spinner, {
    size: "small"
  }));
};