import _extends from "@babel/runtime/helpers/extends";
import _slicedToArray from "@babel/runtime/helpers/slicedToArray";
import _classCallCheck from "@babel/runtime/helpers/classCallCheck";
import _createClass from "@babel/runtime/helpers/createClass";
import _assertThisInitialized from "@babel/runtime/helpers/assertThisInitialized";
import _inherits from "@babel/runtime/helpers/inherits";
import _possibleConstructorReturn from "@babel/runtime/helpers/possibleConstructorReturn";
import _getPrototypeOf from "@babel/runtime/helpers/getPrototypeOf";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
var _excluded = ["isActive", "isDisabled", "isFocused", "isSelected"],
  _excluded2 = ["isActive", "isDisabled", "isSelected"],
  _excluded3 = ["isActive", "isDisabled", "isFocused", "isSelected"],
  _excluded4 = ["getStyles", "Icon", "children", "innerProps", "innerRef"];
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }
/** @jsx jsx */
import { jsx } from '@emotion/react';
import { Component } from 'react';
import RadioIcon from '@atlaskit/icon/glyph/radio';
import CheckboxIcon from '@atlaskit/icon/glyph/checkbox';
import { themed } from '@atlaskit/theme/components';
import { B100, B200, B300, B400, B75, DN200, DN10, DN30, N20A, N0, N100, N20, N30, N70 } from '@atlaskit/theme/colors';
var getPrimitiveStyles = function getPrimitiveStyles(props) {
  var cx = props.cx,
    className = props.className,
    getStyles = props.getStyles,
    isDisabled = props.isDisabled,
    isFocused = props.isFocused,
    isSelected = props.isSelected;
  var styles = {
    alignItems: 'center',
    backgroundColor: isFocused ? "var(--ds-background-neutral-subtle-hovered, ".concat(N20, ")") : 'transparent',
    color: isDisabled ? "var(--ds-text-disabled, inherit)" : 'inherit',
    display: 'flex ',
    paddingBottom: "var(--ds-space-050, 4px)",
    paddingLeft: "var(--ds-space-200, 16px)",
    paddingTop: "var(--ds-space-050, 4px)",
    boxShadow: isFocused ? "inset 2px 0px 0px ".concat("var(--ds-border-focused, ".concat(B400, ")"), ";") : '',
    ':active': {
      backgroundColor: "var(--ds-background-neutral-subtle-pressed, ".concat(N30, ")")
    },
    '@media screen and (-ms-high-contrast: active)': {
      borderLeft: isFocused ? '2px solid transparent' : ''
    }
  };
  var augmentedStyles = _objectSpread(_objectSpread({}, getStyles('option', props)), styles);
  var bemClasses = {
    option: true,
    'option--is-disabled': isDisabled,
    'option--is-focused': isFocused,
    'option--is-selected': isSelected
  };

  // maintain react-select API
  return [augmentedStyles, cx(bemClasses, className)];
};

// maintains function shape
var backgroundColor = themed({
  light: "var(--ds-background-neutral, ".concat(N0, ")"),
  dark: "var(--ds-background-neutral, ".concat(DN10, ")")
});
var transparent = themed({
  light: 'transparent',
  dark: 'transparent'
});

// state of the parent option

// the primary color represents the outer or background element
var getPrimaryColor = function getPrimaryColor(_ref) {
  var isActive = _ref.isActive,
    isDisabled = _ref.isDisabled,
    isFocused = _ref.isFocused,
    isSelected = _ref.isSelected,
    rest = _objectWithoutProperties(_ref, _excluded);
  var color = backgroundColor;
  if (isDisabled && isSelected) {
    color = themed({
      light: "var(--ds-background-disabled, ".concat(B75, ")"),
      dark: "var(--ds-background-disabled, ".concat(DN200, ")")
    });
  } else if (isDisabled) {
    color = themed({
      light: "var(--ds-background-disabled, ".concat(N20A, ")"),
      dark: "var(--ds-background-disabled, ".concat(DN10, ")")
    });
  } else if (isSelected && isActive) {
    color = themed({
      light: "var(--ds-background-selected-bold-pressed, ".concat(B75, ")"),
      dark: "var(--ds-background-selected-bold-pressed, ".concat(B200, ")")
    });
  } else if (isActive) {
    color = themed({
      light: "var(--ds-background-selected-pressed, ".concat(B75, ")"),
      dark: "var(--ds-background-selected-pressed, ".concat(B200, ")")
    });
  } else if (isFocused && isSelected) {
    color = themed({
      light: "var(--ds-background-selected-bold-hovered, ".concat(B300, ")"),
      dark: "var(--ds-background-selected-bold-hovered, ".concat(B75, ")")
    });
  } else if (isFocused) {
    color = themed({
      light: "var(--ds-surface, ".concat(N0, ")"),
      dark: "var(--ds-surface, ".concat(DN30, ")")
    });
  } else if (isSelected) {
    color = themed({
      light: "var(--ds-background-selected-bold, ".concat(B400, ")"),
      dark: "var(--ds-background-selected-bold, ".concat(B100, ")")
    });
  }
  return color(rest);
};

// the secondary color represents the radio dot or checkmark
var getSecondaryColor = function getSecondaryColor(_ref2) {
  var isActive = _ref2.isActive,
    isDisabled = _ref2.isDisabled,
    isSelected = _ref2.isSelected,
    rest = _objectWithoutProperties(_ref2, _excluded2);
  var color = themed({
    light: "var(--ds-surface, ".concat(N0, ")"),
    dark: "var(--ds-surface, ".concat(DN10, ")")
  });
  if (isDisabled && isSelected) {
    color = themed({
      light: "var(--ds-text-disabled, ".concat(N70, ")"),
      dark: "var(--ds-text-disabled, ".concat(DN10, ")")
    });
  } else if (isActive && isSelected && !isDisabled) {
    color = themed({
      light: "var(--ds-surface, ".concat(B400, ")"),
      dark: "var(--ds-surface, ".concat(DN10, ")")
    });
  } else if (!isSelected) {
    color = transparent;
  }
  return color(rest);
};

// the border color surrounds the checkbox/radio
var getBorderColor = function getBorderColor(_ref3) {
  var isActive = _ref3.isActive,
    isDisabled = _ref3.isDisabled,
    isFocused = _ref3.isFocused,
    isSelected = _ref3.isSelected,
    rest = _objectWithoutProperties(_ref3, _excluded3);
  if (isDisabled && isSelected) {
    return "var(--ds-background-disabled, ".concat(B400, ")");
  } else if (isDisabled) {
    return "var(--ds-background-disabled, ".concat(N100, ")");
  } else if (isSelected && isActive) {
    return "var(--ds-background-selected-bold-pressed, ".concat(B400, ")");
  } else if (isActive) {
    return "var(--ds-background-selected-bold, ".concat(B400, ")");
  } else if (isFocused && isSelected) {
    return "var(--ds-background-selected-bold-hovered, ".concat(B400, ")");
  } else if (isFocused) {
    return "var(--ds-border-input, ".concat(N100, ")");
  } else if (isSelected) {
    return "var(--ds-background-selected-bold, ".concat(B400, ")");
  }
  return "var(--ds-border-input, ".concat(N100, ")");
};
var ControlOption = /*#__PURE__*/function (_Component) {
  _inherits(ControlOption, _Component);
  var _super = _createSuper(ControlOption);
  function ControlOption() {
    var _this;
    _classCallCheck(this, ControlOption);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    _defineProperty(_assertThisInitialized(_this), "state", {
      isActive: false
    });
    _defineProperty(_assertThisInitialized(_this), "onMouseDown", function () {
      return _this.setState({
        isActive: true
      });
    });
    _defineProperty(_assertThisInitialized(_this), "onMouseUp", function () {
      return _this.setState({
        isActive: false
      });
    });
    _defineProperty(_assertThisInitialized(_this), "onMouseLeave", function () {
      return _this.setState({
        isActive: false
      });
    });
    return _this;
  }
  _createClass(ControlOption, [{
    key: "render",
    value: function render() {
      var _this$props = this.props,
        getStyles = _this$props.getStyles,
        Icon = _this$props.Icon,
        children = _this$props.children,
        innerProps = _this$props.innerProps,
        innerRef = _this$props.innerRef,
        rest = _objectWithoutProperties(_this$props, _excluded4);

      // prop assignment
      var props = _objectSpread(_objectSpread({}, innerProps), {}, {
        onMouseDown: this.onMouseDown,
        onMouseUp: this.onMouseUp,
        onMouseLeave: this.onMouseLeave
      });
      var _getPrimitiveStyles = getPrimitiveStyles(_objectSpread({
          getStyles: getStyles
        }, rest)),
        _getPrimitiveStyles2 = _slicedToArray(_getPrimitiveStyles, 2),
        styles = _getPrimitiveStyles2[0],
        classes = _getPrimitiveStyles2[1];
      return (
        /**
         * TODO Fix this type error
         * @see https://product-fabric.atlassian.net/browse/DSP-6063
         */
        // @ts-ignore
        jsx("div", _extends({
          css: styles,
          className: classes,
          ref: innerRef
        }, props), jsx("div", {
          css: {
            alignItems: 'center',
            display: 'flex ',
            flexShrink: 0,
            paddingRight: "var(--ds-space-050, 4px)",
            // Here we are adding a border to the Checkbox and Radio SVG icons
            // This is an a11y fix for Select only for now but it may be rolled
            // into the `@atlaskit/icon` package's Checkbox and Radio SVGs later
            '& svg rect, & svg circle:first-of-type': {
              stroke: getBorderColor(_objectSpread(_objectSpread({}, this.props), this.state)),
              strokeWidth: '2px',
              strokeLinejoin: 'round'
            }
          }
        }, !!Icon ? jsx(Icon, {
          label: "",
          primaryColor: getPrimaryColor(_objectSpread(_objectSpread({}, this.props), this.state)),
          secondaryColor: getSecondaryColor(_objectSpread(_objectSpread({}, this.props), this.state))
        }) : null), jsx("div", {
          css: {
            textOverflow: 'ellipsis',
            overflowX: 'hidden',
            flexGrow: 1,
            whiteSpace: 'nowrap'
          }
        }, children))
      );
    }
  }]);
  return ControlOption;
}(Component);
export var CheckboxOption = function CheckboxOption(props) {
  return jsx(ControlOption, _extends({
    Icon: CheckboxIcon
  }, props));
};
export var RadioOption = function RadioOption(props) {
  return jsx(ControlOption, _extends({
    Icon: RadioIcon
  }, props));
};