import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
import _classCallCheck from "@babel/runtime/helpers/classCallCheck";
import _createClass from "@babel/runtime/helpers/createClass";
import _assertThisInitialized from "@babel/runtime/helpers/assertThisInitialized";
import _inherits from "@babel/runtime/helpers/inherits";
import _possibleConstructorReturn from "@babel/runtime/helpers/possibleConstructorReturn";
import _getPrototypeOf from "@babel/runtime/helpers/getPrototypeOf";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
var _excluded = ["styles", "validationState", "isInvalid", "spacing", "isMulti", "appearance", "ariaLiveMessages"];
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
import React, { Component } from 'react';
import { mergeStyles } from 'react-select';
import memoizeOne from 'memoize-one';
import isEqual from 'react-fast-compare';
import * as defaultComponents from './components';
import baseStyles from './styles';
import { onFocus, isOptionsGrouped } from './utils/grouped-options-announcement';
export default function createSelect(WrappedComponent) {
  var _class;
  return _class = /*#__PURE__*/function (_Component) {
    _inherits(AtlaskitSelect, _Component);
    var _super = _createSuper(AtlaskitSelect);
    function AtlaskitSelect(props) {
      var _this;
      _classCallCheck(this, AtlaskitSelect);
      _this = _super.call(this, props);
      _defineProperty(_assertThisInitialized(_this), "components", {});
      _defineProperty(_assertThisInitialized(_this), "select", null);
      _defineProperty(_assertThisInitialized(_this), "cacheComponents", function (components) {
        _this.components = _objectSpread(_objectSpread({}, defaultComponents), components);
      });
      _defineProperty(_assertThisInitialized(_this), "onSelectRef", function (ref) {
        _this.select = ref;
      });
      _this.cacheComponents = memoizeOne(_this.cacheComponents, isEqual).bind(_assertThisInitialized(_this));
      _this.cacheComponents(props.components || {});
      return _this;
    }
    _createClass(AtlaskitSelect, [{
      key: "UNSAFE_componentWillReceiveProps",
      value: function UNSAFE_componentWillReceiveProps(nextProps) {
        this.cacheComponents(nextProps.components);
      }
    }, {
      key: "focus",
      value: function focus() {
        if (this.select) {
          this.select.focus();
        }
      }
    }, {
      key: "blur",
      value: function blur() {
        if (this.select) {
          this.select.blur();
        }
      }
    }, {
      key: "render",
      value: function render() {
        var _this$props = this.props,
          styles = _this$props.styles,
          validationState = _this$props.validationState,
          isInvalid = _this$props.isInvalid,
          spacing = _this$props.spacing,
          isMulti = _this$props.isMulti,
          appearance = _this$props.appearance,
          ariaLiveMessages = _this$props.ariaLiveMessages,
          props = _objectWithoutProperties(_this$props, _excluded);
        var isCompact = spacing === 'compact';

        // props must be spread first to stop `components` being overridden
        return /*#__PURE__*/React.createElement(WrappedComponent, _extends({
          ref: this.onSelectRef,
          isMulti: isMulti,
          "aria-live": "assertive",
          ariaLiveMessages: isOptionsGrouped(this.props.options) ? _objectSpread({
            onFocus: onFocus
          }, ariaLiveMessages) : _objectSpread({}, ariaLiveMessages)
        }, props, {
          components: this.components,
          styles: mergeStyles(baseStyles(
          // This will cover both props for invalid state while giving priority to isInvalid. When cleaning up validationState, we can just keep the inner condition.
          typeof isInvalid !== 'undefined' ? isInvalid ? 'error' : 'default' : validationState, isCompact, this.props.appearance || 'default'), styles)
        }));
      }
    }]);
    return AtlaskitSelect;
  }(Component), _defineProperty(_class, "defaultProps", {
    validationState: 'default',
    // TODO: uncomment the next line when cleaning up validationState prop so it has a default value
    // isInvalid: false,
    spacing: 'default',
    onClickPreventDefault: true,
    tabSelectsValue: false,
    components: {},
    styles: {}
  }), _class;
}