import React, { PureComponent, ReactNode } from 'react';
import { GroupBase } from 'react-select';
import BaseSelect from 'react-select/base';
import { PopperProps } from 'react-popper';
import { defaultComponents } from './components';
import { OptionType, ActionMeta, ReactSelectProps, StylesConfig, ValueType, ValidationState } from '../types';
import { UnbindFn } from 'bind-event-listener';
type defaultModifiers = 'offset' | 'preventOverflow';
type PopperPropsNoChildren<Modifiers> = Omit<PopperProps<Modifiers>, 'children'>;
interface PopupSelectTriggerProps {
    ref: any;
    'aria-haspopup': 'true';
    'aria-expanded': boolean;
    'aria-controls'?: string;
}
export type ModifierList = 'offset' | 'computeStyles' | 'preventOverflow' | 'handleFlipStyle' | 'flip' | 'popperOffsets' | 'arrow' | 'hide' | 'eventListeners' | 'applyStyles';
export interface PopupSelectProps<Option = OptionType, IsMulti extends boolean = false, Modifiers = ModifierList> extends ReactSelectProps<Option, IsMulti> {
    /**
     * Defines whether the menu should close when selected. Defaults to "true"
     */
    closeMenuOnSelect?: boolean;
    /**
     * The footer content shown at the bottom of the Popup, underneath the Select options
     */
    footer?: ReactNode;
    /**
      The props passed down to React Popper.
  
      Use these to override the default positioning strategy, behaviour and placement used by this library.
      For more information, see the Popper Props section below, or [React Popper documentation](https://popper.js.org/react-popper/v2/render-props).
  
     */
    popperProps?: PopperPropsNoChildren<Modifiers>;
    /**
     * The maximum number of options the select can contain without rendering the search field. Defaults to 5.
     */
    searchThreshold?: number;
    /**
     * If false, renders a select with no search field. If true, renders a search field in the select when the
     * number of options exceeds the `searchThreshold`. Defaults to true.
     */
    isSearchable?: boolean;
    /**
     * The maximum width for the popup menu. Can be a number, representing width in pixels,
     * or a string containing a CSS length datatype.
     */
    maxMenuWidth?: number | string;
    /**
     * The maximum width for the popup menu. Can be a number, representing width in pixels,
     * or a string containing a CSS length datatype.
     */
    minMenuWidth?: number | string;
    /**
      Render props used to anchor the popup to your content.
  
      Make this an interactive element, such as an @atlaskit/button component.
  
      The provided render props in `options` are detailed below:
      - `isOpen`: The current state of the popup.
          Use this to change the appearance of your target based on the state of your component
      - `ref`: Pass this ref to the element the Popup should be attached to
      - `aria-haspopup`, `aria-expanded`, `aria-controls`: Spread these onto a target element to
          ensure your experience is accessible
     */
    target?: (options: PopupSelectTriggerProps & {
        isOpen: boolean;
    }) => ReactNode;
    isOpen?: boolean;
    defaultIsOpen?: boolean;
    /** The prop indicates if the component has a compacted look */
    spacing?: string;
    /** @deprecated Use isInvalid instead. The state of validation if used in a form */
    validationState?: ValidationState;
    /** This prop indicates if the component is in an error state */
    isInvalid?: boolean;
    testId?: string;
}
interface State<Modifiers = string> {
    /**
     * TODO: This type should be cleaned up with `platform.design-system-team.popup-select-render-perf_i0s6m`.
     *  - If discarded, revert to `focusLockEnabled: boolean`
     *  - If kept, delete this type.
     */
    focusLockEnabled?: boolean;
    isOpen: boolean;
    mergedComponents: Object;
    mergedPopperProps: PopperPropsNoChildren<defaultModifiers | Modifiers>;
}
export default class PopupSelect<Option = OptionType, IsMulti extends boolean = false, Modifiers = ModifierList> extends PureComponent<PopupSelectProps<Option, IsMulti, Modifiers>, State> {
    menuRef: HTMLElement | null;
    selectRef: BaseSelect<Option, IsMulti> | null;
    targetRef: HTMLElement | null;
    unbindWindowClick: UnbindFn | null;
    unbindWindowKeydown: UnbindFn | null;
    defaultStyles: StylesConfig<Option, IsMulti>;
    isOpenControlled: boolean;
    defaultOpenState: boolean | undefined;
    state: {
        isOpen: boolean;
        mergedComponents: {
            Control: React.FC<import("../types").ControlProps<OptionType, boolean>>;
            DropdownIndicator: () => import("@emotion/react").jsx.JSX.Element;
            Menu: ({ children, innerProps, ...props }: import("../types").MenuProps<OptionType, boolean>) => import("@emotion/react").jsx.JSX.Element; /**
              The props passed down to React Popper.
          
              Use these to override the default positioning strategy, behaviour and placement used by this library.
              For more information, see the Popper Props section below, or [React Popper documentation](https://popper.js.org/react-popper/v2/render-props).
          
             */
        };
        mergedPopperProps: PopperPropsNoChildren<string>;
        focusLockEnabled?: undefined;
    } | {
        focusLockEnabled: boolean;
        isOpen: boolean;
        mergedComponents: {
            Control: React.FC<import("../types").ControlProps<OptionType, boolean>>;
            DropdownIndicator: () => import("@emotion/react").jsx.JSX.Element;
            Menu: ({ children, innerProps, ...props }: import("../types").MenuProps<OptionType, boolean>) => import("@emotion/react").jsx.JSX.Element; /**
              The props passed down to React Popper.
          
              Use these to override the default positioning strategy, behaviour and placement used by this library.
              For more information, see the Popper Props section below, or [React Popper documentation](https://popper.js.org/react-popper/v2/render-props).
          
             */
        };
        mergedPopperProps: PopperPropsNoChildren<string>;
    };
    popperWrapperId: string;
    static defaultProps: {
        closeMenuOnSelect: boolean;
        components: {};
        maxMenuHeight: number;
        maxMenuWidth: number;
        minMenuWidth: number;
        popperProps: {};
        isSearchable: boolean;
        searchThreshold: number;
        styles: {};
        options: never[];
    };
    static getDerivedStateFromProps(props: PopupSelectProps<OptionType>, state: State): Partial<State<string>> | null;
    componentDidMount(): void;
    componentWillUnmount(): void;
    componentDidUpdate(prevProps: PopupSelectProps<Option, IsMulti, Modifiers>): void;
    handleKeyDown: (event: KeyboardEvent) => void;
    handleClick: ({ target }: MouseEvent) => void;
    handleSelectChange: (value: ValueType<Option, IsMulti>, actionMeta: ActionMeta<Option>) => void;
    handleFirstPopperUpdate: () => void;
    /**
     * Opens the popup
     *
     * @param options.controlOverride  - Force the popup to open when it's open state is being controlled
     */
    open: (options?: {
        controlOverride?: boolean;
    }) => void;
    /**
     * Closes the popup
     *
     * @param options.controlOverride  - Force the popup to close when it's open state is being controlled
     */
    close: (options?: {
        controlOverride?: boolean;
    }) => void;
    resolveTargetRef: (popperRef: React.Ref<HTMLElement>) => (ref: HTMLElement) => void;
    resolveMenuRef: (popperRef: React.Ref<HTMLElement>) => (ref: HTMLElement) => void;
    getSelectRef: (ref: BaseSelect<Option, IsMulti>) => void;
    getSelectStyles: import("memoize-one").MemoizedFn<(defaultStyles: StylesConfig<Option, IsMulti>, propStyles: StylesConfig<Option, IsMulti> | undefined) => {
        clearIndicator?: import("react-select/dist/declarations/src/styles").StylesConfigFunction<import("react-select").ClearIndicatorProps<Option, IsMulti, GroupBase<Option>>> | undefined;
        container?: import("react-select/dist/declarations/src/styles").StylesConfigFunction<import("react-select").ContainerProps<Option, IsMulti, GroupBase<Option>>> | undefined;
        control?: import("react-select/dist/declarations/src/styles").StylesConfigFunction<import("react-select").ControlProps<Option, IsMulti, GroupBase<Option>>> | undefined;
        dropdownIndicator?: import("react-select/dist/declarations/src/styles").StylesConfigFunction<import("react-select").DropdownIndicatorProps<Option, IsMulti, GroupBase<Option>>> | undefined;
        group?: import("react-select/dist/declarations/src/styles").StylesConfigFunction<import("react-select").GroupProps<Option, IsMulti, GroupBase<Option>>> | undefined;
        groupHeading?: import("react-select/dist/declarations/src/styles").StylesConfigFunction<import("react-select").GroupHeadingProps<Option, IsMulti, GroupBase<Option>>> | undefined;
        indicatorsContainer?: import("react-select/dist/declarations/src/styles").StylesConfigFunction<import("react-select").IndicatorsContainerProps<Option, IsMulti, GroupBase<Option>>> | undefined;
        indicatorSeparator?: import("react-select/dist/declarations/src/styles").StylesConfigFunction<import("react-select").IndicatorSeparatorProps<Option, IsMulti, GroupBase<Option>>> | undefined;
        input?: import("react-select/dist/declarations/src/styles").StylesConfigFunction<import("react-select").InputProps<Option, IsMulti, GroupBase<Option>>> | undefined;
        loadingIndicator?: import("react-select/dist/declarations/src/styles").StylesConfigFunction<import("react-select").LoadingIndicatorProps<Option, IsMulti, GroupBase<Option>>> | undefined;
        loadingMessage?: import("react-select/dist/declarations/src/styles").StylesConfigFunction<import("react-select").NoticeProps<Option, IsMulti, GroupBase<Option>>> | undefined;
        menu?: import("react-select/dist/declarations/src/styles").StylesConfigFunction<import("react-select").MenuProps<Option, IsMulti, GroupBase<Option>>> | undefined;
        menuList?: import("react-select/dist/declarations/src/styles").StylesConfigFunction<import("react-select").MenuListProps<Option, IsMulti, GroupBase<Option>>> | undefined;
        menuPortal?: import("react-select/dist/declarations/src/styles").StylesConfigFunction<import("react-select/dist/declarations/src/components/Menu").PortalStyleArgs> | undefined;
        multiValue?: import("react-select/dist/declarations/src/styles").StylesConfigFunction<import("react-select").MultiValueProps<Option, IsMulti, GroupBase<Option>>> | undefined;
        multiValueLabel?: import("react-select/dist/declarations/src/styles").StylesConfigFunction<import("react-select").MultiValueProps<Option, IsMulti, GroupBase<Option>>> | undefined;
        multiValueRemove?: import("react-select/dist/declarations/src/styles").StylesConfigFunction<import("react-select").MultiValueProps<Option, IsMulti, GroupBase<Option>>> | undefined;
        noOptionsMessage?: import("react-select/dist/declarations/src/styles").StylesConfigFunction<import("react-select").NoticeProps<Option, IsMulti, GroupBase<Option>>> | undefined;
        option?: import("react-select/dist/declarations/src/styles").StylesConfigFunction<import("react-select").OptionProps<Option, IsMulti, GroupBase<Option>>> | undefined;
        placeholder?: import("react-select/dist/declarations/src/styles").StylesConfigFunction<import("react-select").PlaceholderProps<Option, IsMulti, GroupBase<Option>>> | undefined;
        singleValue?: import("react-select/dist/declarations/src/styles").StylesConfigFunction<import("react-select").SingleValueProps<Option, IsMulti, GroupBase<Option>>> | undefined;
        valueContainer?: import("react-select/dist/declarations/src/styles").StylesConfigFunction<import("react-select").ValueContainerProps<Option, IsMulti, GroupBase<Option>>> | undefined;
    }>;
    getSelectComponents: import("memoize-one").MemoizedFn<(mergedComponents: typeof defaultComponents, showSearchControl: boolean | undefined) => Partial<{
        ClearIndicator: <Option_1, IsMulti_1 extends boolean, Group extends GroupBase<Option_1>>(props: import("react-select").ClearIndicatorProps<Option_1, IsMulti_1, Group>) => import("@emotion/react").jsx.JSX.Element;
        Control: <Option_1, IsMulti_1 extends boolean, Group_1 extends GroupBase<Option_1>>(props: import("react-select").ControlProps<Option_1, IsMulti_1, Group_1>) => import("@emotion/react").jsx.JSX.Element;
        DropdownIndicator: <Option_2, IsMulti_2 extends boolean, Group_2 extends GroupBase<Option_2>>(props: import("react-select").DropdownIndicatorProps<Option_2, IsMulti_2, Group_2>) => import("@emotion/react").jsx.JSX.Element;
        DownChevron: (props: import("react-select/dist/declarations/src/components/indicators").DownChevronProps) => import("@emotion/react").jsx.JSX.Element;
        CrossIcon: (props: import("react-select/dist/declarations/src/components/indicators").CrossIconProps) => import("@emotion/react").jsx.JSX.Element;
        Group: <Option_3, IsMulti_3 extends boolean, Group_3 extends GroupBase<Option_3>>(props: import("react-select").GroupProps<Option_3, IsMulti_3, Group_3>) => import("@emotion/react").jsx.JSX.Element;
        GroupHeading: <Option_4, IsMulti_4 extends boolean, Group_4 extends GroupBase<Option_4>>(props: import("react-select").GroupHeadingProps<Option_4, IsMulti_4, Group_4>) => import("@emotion/react").jsx.JSX.Element;
        IndicatorsContainer: <Option_5, IsMulti_5 extends boolean, Group_5 extends GroupBase<Option_5>>(props: import("react-select").IndicatorsContainerProps<Option_5, IsMulti_5, Group_5>) => import("@emotion/react").jsx.JSX.Element;
        IndicatorSeparator: <Option_6, IsMulti_6 extends boolean, Group_6 extends GroupBase<Option_6>>(props: import("react-select").IndicatorSeparatorProps<Option_6, IsMulti_6, Group_6>) => import("@emotion/react").jsx.JSX.Element;
        Input: <Option_7, IsMulti_7 extends boolean, Group_7 extends GroupBase<Option_7>>(props: import("react-select").InputProps<Option_7, IsMulti_7, Group_7>) => import("@emotion/react").jsx.JSX.Element;
        LoadingIndicator: {
            <Option_8, IsMulti_8 extends boolean, Group_8 extends GroupBase<Option_8>>(props: import("react-select").LoadingIndicatorProps<Option_8, IsMulti_8, Group_8>): import("@emotion/react").jsx.JSX.Element;
            defaultProps: {
                size: number;
            };
        };
        Menu: <Option_9, IsMulti_9 extends boolean, Group_9 extends GroupBase<Option_9>>(props: import("react-select").MenuProps<Option_9, IsMulti_9, Group_9>) => import("@emotion/react").jsx.JSX.Element;
        MenuList: <Option_10, IsMulti_10 extends boolean, Group_10 extends GroupBase<Option_10>>(props: import("react-select").MenuListProps<Option_10, IsMulti_10, Group_10>) => import("@emotion/react").jsx.JSX.Element;
        MenuPortal: typeof import("react-select/dist/declarations/src/components/Menu").MenuPortal;
        LoadingMessage: {
            <Option_11, IsMulti_11 extends boolean, Group_11 extends GroupBase<Option_11>>(props: import("react-select").NoticeProps<Option_11, IsMulti_11, Group_11>): import("@emotion/react").jsx.JSX.Element;
            defaultProps: {
                children: string;
            };
        };
        NoOptionsMessage: {
            <Option_12, IsMulti_12 extends boolean, Group_12 extends GroupBase<Option_12>>(props: import("react-select").NoticeProps<Option_12, IsMulti_12, Group_12>): import("@emotion/react").jsx.JSX.Element;
            defaultProps: {
                children: string;
            };
        };
        MultiValue: <Option_13, IsMulti_13 extends boolean, Group_13 extends GroupBase<Option_13>>(props: import("react-select").MultiValueProps<Option_13, IsMulti_13, Group_13>) => import("@emotion/react").jsx.JSX.Element;
        MultiValueContainer: <Option_14, IsMulti_14 extends boolean, Group_14 extends GroupBase<Option_14>>({ children, innerProps, }: import("react-select").MultiValueGenericProps<Option_14, IsMulti_14, Group_14>) => import("@emotion/react").jsx.JSX.Element;
        MultiValueLabel: <Option_14_1, IsMulti_14_1 extends boolean, Group_14_1 extends GroupBase<Option_14_1>>({ children, innerProps, }: import("react-select").MultiValueGenericProps<Option_14_1, IsMulti_14_1, Group_14_1>) => import("@emotion/react").jsx.JSX.Element;
        MultiValueRemove: typeof import("react-select/dist/declarations/src/components/MultiValue").MultiValueRemove;
        Option: <Option_15, IsMulti_15 extends boolean, Group_15 extends GroupBase<Option_15>>(props: import("react-select").OptionProps<Option_15, IsMulti_15, Group_15>) => import("@emotion/react").jsx.JSX.Element;
        Placeholder: <Option_16, IsMulti_16 extends boolean, Group_16 extends GroupBase<Option_16>>(props: import("react-select").PlaceholderProps<Option_16, IsMulti_16, Group_16>) => import("@emotion/react").jsx.JSX.Element;
        SelectContainer: <Option_17, IsMulti_17 extends boolean, Group_17 extends GroupBase<Option_17>>(props: import("react-select").ContainerProps<Option_17, IsMulti_17, Group_17>) => import("@emotion/react").jsx.JSX.Element;
        SingleValue: <Option_18, IsMulti_18 extends boolean, Group_18 extends GroupBase<Option_18>>(props: import("react-select").SingleValueProps<Option_18, IsMulti_18, Group_18>) => import("@emotion/react").jsx.JSX.Element;
        ValueContainer: <Option_19, IsMulti_19 extends boolean, Group_19 extends GroupBase<Option_19>>(props: import("react-select").ValueContainerProps<Option_19, IsMulti_19, Group_19>) => import("@emotion/react").jsx.JSX.Element;
    }>>;
    getItemCount: () => number;
    getMaxHeight: () => number | undefined;
    showSearchControl: () => boolean | undefined;
    renderSelect: () => JSX.Element | null;
    render(): JSX.Element;
}
export {};
