"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = Tab;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = require("@emotion/react");
var _dsExplorations = require("@atlaskit/ds-explorations");
var _hooks = require("../hooks");
/** @jsx jsx */

/**
 * __Tab__
 *
 * Tab represents an indivudal Tab displayed in a TabList.
 *
 * - [Examples](https://atlassian.design/components/tabs/examples)
 * - [Code](https://atlassian.design/components/tabs/code)
 * - [Usage](https://atlassian.design/components/tabs/usage)
 */
function Tab(_ref) {
  var children = _ref.children,
    testId = _ref.testId;
  var tabAttributes = (0, _hooks.useTab)();
  return (0, _react.jsx)(_dsExplorations.UNSAFE_Box, (0, _extends2.default)({
    as: "div",
    testId: testId
  }, tabAttributes), (0, _react.jsx)(_dsExplorations.UNSAFE_Text, {
    shouldTruncate: true,
    UNSAFE_style: {
      color: 'inherit'
    }
  }, children));
}