"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _toArray2 = _interopRequireDefault(require("@babel/runtime/helpers/toArray"));
var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));
var _react = require("react");
var _react2 = require("@emotion/react");
var _usePlatformLeafEventHandler = require("@atlaskit/analytics-next/usePlatformLeafEventHandler");
var _dsExplorations = require("@atlaskit/ds-explorations");
var _components = require("@atlaskit/theme/components");
var _context = require("../internal/context");
var _styles = require("../internal/styles");
var _utils = require("../internal/utils");
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { (0, _defineProperty2.default)(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; } /** @jsx jsx */
var analyticsAttributes = {
  componentName: 'tabs',
  packageName: "@atlaskit/tabs",
  packageVersion: "13.4.3"
};
var getTabPanelWithContext = function getTabPanelWithContext(_ref) {
  var tabPanel = _ref.tabPanel,
    index = _ref.index,
    isSelected = _ref.isSelected,
    tabsId = _ref.tabsId;
  return (
    // Ensure tabPanel exists in case it has been removed
    tabPanel && (0, _react2.jsx)(_context.TabPanelContext.Provider, {
      value: {
        role: 'tabpanel',
        id: "".concat(tabsId, "-").concat(index, "-tab"),
        hidden: isSelected ? undefined : true,
        'aria-labelledby': "".concat(tabsId, "-").concat(index),
        onMouseDown: _utils.onMouseDownBlur,
        tabIndex: isSelected ? 0 : -1
      },
      key: index
    }, tabPanel)
  );
};

/**
 * __Tabs__
 *
 * Tabs acts as a container for all Tab components.
 *
 * - [Examples](https://atlassian.design/components/tabs/examples)
 * - [Code](https://atlassian.design/components/tabs/code)
 * - [Usage](https://atlassian.design/components/tabs/usage)
 */
var Tabs = function Tabs(props) {
  var _props$shouldUnmountT = props.shouldUnmountTabPanelOnChange,
    shouldUnmountTabPanelOnChange = _props$shouldUnmountT === void 0 ? false : _props$shouldUnmountT,
    SelectedType = props.selected,
    defaultSelected = props.defaultSelected,
    onChangeProp = props.onChange,
    id = props.id,
    analyticsContext = props.analyticsContext,
    children = props.children,
    testId = props.testId;
  var _useGlobalTheme = (0, _components.useGlobalTheme)(),
    mode = _useGlobalTheme.mode;
  var _useState = (0, _react.useState)(SelectedType || defaultSelected || 0),
    _useState2 = (0, _slicedToArray2.default)(_useState, 2),
    selectedState = _useState2[0],
    setSelected = _useState2[1];
  var selected = SelectedType === undefined ? selectedState : SelectedType;
  var childrenArray = _react.Children.toArray(children)
  // Don't include any conditional children
  .filter(function (child) {
    return Boolean(child);
  });
  // First child should be a tabList followed by tab panels
  var _childrenArray = (0, _toArray2.default)(childrenArray),
    tabList = _childrenArray[0],
    tabPanels = _childrenArray.slice(1);

  // Keep track of visited and add to a set
  var visited = (0, _react.useRef)(new Set([selected]));
  if (!visited.current.has(selected)) {
    visited.current.add(selected);
  }
  var onChange = (0, _react.useCallback)(function (index, analyticsEvent) {
    if (onChangeProp) {
      onChangeProp(index, analyticsEvent);
    }
    setSelected(index);
  }, [onChangeProp]);
  var onChangeAnalytics = (0, _usePlatformLeafEventHandler.usePlatformLeafEventHandler)(_objectSpread({
    fn: onChange,
    action: 'clicked',
    analyticsData: analyticsContext
  }, analyticsAttributes));
  var tabPanelsWithContext = shouldUnmountTabPanelOnChange ? getTabPanelWithContext({
    tabPanel: tabPanels[selected],
    index: selected,
    isSelected: true,
    tabsId: id
  }) :
  // If a panel has already been visited, don't unmount it
  Array.from(visited.current).map(function (tabIndex) {
    return getTabPanelWithContext({
      tabPanel: tabPanels[tabIndex],
      index: tabIndex,
      isSelected: tabIndex === selected,
      tabsId: id
    });
  });
  var tabsStyles = (0, _react.useMemo)(function () {
    return (0, _styles.getTabsStyles)(mode);
  }, [mode]);
  return (
    // Only styles that affect the Tabs container itself have been applied via primitives.
    // The other styles applied through the CSS prop are there for styling children
    // through inheritance. This is important for custom cases that use the useTabPanel(),
    // which applies accessibility atributes that we use as a styling hook.
    (0, _react2.jsx)(_dsExplorations.UNSAFE_Box, {
      as: "div",
      testId: testId,
      display: "flex",
      flexDirection: "column",
      UNSAFE_style: {
        maxWidth: '100%',
        minHeight: '0%',
        flexBasis: '100%',
        flexGrow: 1
      }
      // eslint-disable-next-line @atlaskit/design-system/consistent-css-prop-usage
      ,
      css: tabsStyles
    }, (0, _react2.jsx)(_context.TabListContext.Provider, {
      value: {
        selected: selected,
        onChange: onChangeAnalytics,
        tabsId: id
      }
    }, tabList), (0, _react2.jsx)(_react.Fragment, null, tabPanelsWithContext))
  );
};
var _default = Tabs;
exports.default = _default;