"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useTabPanel = exports.useTabList = exports.useTab = void 0;
var _react = require("react");
var _context = require("./internal/context");
var useTab = function useTab() {
  var tabData = (0, _react.useContext)(_context.TabContext);
  if (tabData == null || typeof tabData === 'undefined') {
    throw Error('@atlaskit/tabs: A Tab must have a TabList parent.');
  }
  return tabData;
};
exports.useTab = useTab;
var useTabList = function useTabList() {
  var tabListData = (0, _react.useContext)(_context.TabListContext);
  if (tabListData === null || typeof tabListData === 'undefined') {
    throw Error('@atlaskit/tabs: A TabList must have a Tabs parent.');
  }
  return tabListData;
};
exports.useTabList = useTabList;
var useTabPanel = function useTabPanel() {
  var tabPanelData = (0, _react.useContext)(_context.TabPanelContext);
  if (tabPanelData === null || typeof tabPanelData === 'undefined') {
    throw Error('@atlaskit/tabs:  A TabPanel must have a Tabs parent.');
  }
  return tabPanelData;
};
exports.useTabPanel = useTabPanel;