"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTabPanelFocusColor = exports.getTabLineColor = exports.getTabColors = void 0;
var _colors = require("@atlaskit/theme/colors");
var tabColorMap = {
  light: {
    labelColor: "var(--ds-text-subtle, ".concat(_colors.N500, ")"),
    activeLabelColor: "var(--ds-text, ".concat(_colors.B500, ")"),
    hoverLabelColor: "var(--ds-text-subtle, ".concat(_colors.B400, ")"),
    selectedColor: "var(--ds-text-selected, ".concat(_colors.B400, ")"),
    focusBorderColor: "var(--ds-border-focused, ".concat(_colors.B100, ")")
  },
  dark: {
    labelColor: "var(--ds-text-subtle, ".concat(_colors.DN400, ")"),
    activeLabelColor: "var(--ds-text, ".concat(_colors.B200, ")"),
    hoverLabelColor: "var(--ds-text-subtle, ".concat(_colors.B75, ")"),
    selectedColor: "var(--ds-text-selected, ".concat(_colors.B75, ")"),
    focusBorderColor: "var(--ds-border-focused, ".concat(_colors.B75, ")")
  }
};
var getTabColors = function getTabColors(mode) {
  return tabColorMap[mode];
};
exports.getTabColors = getTabColors;
var tabLineColorMap = {
  light: {
    lineColor: "var(--ds-border, ".concat(_colors.N30, ")"),
    hoveredColor: "var(--ds-border, transparent)",
    activeColor: "var(--ds-border, transparent)",
    selectedColor: "var(--ds-border-selected, ".concat(_colors.B400, ")")
  },
  dark: {
    lineColor: "var(--ds-border, ".concat(_colors.DN0, ")"),
    hoveredColor: "var(--ds-border, transparent)",
    activeColor: "var(--ds-border, transparent)",
    selectedColor: "var(--ds-border-selected, ".concat(_colors.B75, ")")
  }
};
var getTabLineColor = function getTabLineColor(mode) {
  return tabLineColorMap[mode];
};
exports.getTabLineColor = getTabLineColor;
var tabPanelFocusColorMap = {
  light: "var(--ds-border-focused, ".concat(_colors.B100, ")"),
  dark: "var(--ds-border-focused, ".concat(_colors.B75, ")")
};
var getTabPanelFocusColor = function getTabPanelFocusColor(mode) {
  return tabPanelFocusColorMap[mode];
};
exports.getTabPanelFocusColor = getTabPanelFocusColor;