"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTabsStyles = exports.getTabStyles = exports.getTabListStyles = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = require("@emotion/react");
var _colors = require("./colors");
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { (0, _defineProperty2.default)(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }
var tabLeftRightPadding = "var(--ds-space-100, 8px)";
var tabTopBottomPadding = "var(--ds-space-050, 4px)";
// TODO this should probably be `border.width.indicator`
var underlineHeight = "var(--ds-border-width-outline, 2px)";
var highContrastFocusStyles = {
  outline: "var(--ds-border-width, 1px)".concat(" solid")
};

// Required so the focus ring is visible in high contrast mode
var highContrastFocusRing = {
  '@media screen and (forced-colors: active), screen and (-ms-high-contrast: active)': {
    '&:focus-visible': highContrastFocusStyles,
    '@supports not selector(*:focus-visible)': {
      '&:focus': highContrastFocusStyles
    }
  }
};
var tabFocusStyles = function tabFocusStyles(mode) {
  return {
    boxShadow: "0 0 0 2px ".concat((0, _colors.getTabPanelFocusColor)(mode), " inset"),
    borderRadius: "var(--ds-border-radius, 3px)",
    outline: 'none'
  };
};
var getTabPanelStyles = function getTabPanelStyles(mode) {
  return _objectSpread({
    flexGrow: 1,
    /*
      NOTE min-height set to 0% because of Firefox bug
      FF http://stackoverflow.com/questions/28636832/firefox-overflow-y-not-working-with-nested-flexbox
    */
    minHeight: '0%',
    display: 'flex',
    padding: "0 ".concat(tabLeftRightPadding),
    '&:focus-visible': tabFocusStyles(mode),
    '@supports not selector(*:focus-visible)': {
      '&:focus': tabFocusStyles(mode)
    }
  }, highContrastFocusRing);
};
var getTabsStyles = function getTabsStyles(mode) {
  return (
    // eslint-disable-next-line @repo/internal/styles/no-exported-styles
    (0, _react.css)({
      '& [role="tabpanel"]': getTabPanelStyles(mode),
      // The hidden attribute doesn't work on flex elements
      // Change display to be none
      // eslint-disable-next-line @repo/internal/styles/no-nested-styles
      '& > [hidden]': {
        display: 'none'
      }
    })
  );
};
exports.getTabsStyles = getTabsStyles;
var tabLineStyles = {
  content: '""',
  borderRadius: "var(--ds-border-radius-050, 2px)",
  bottom: 0,
  margin: 0,
  position: 'absolute',
  width: 'inherit',
  left: tabLeftRightPadding,
  right: tabLeftRightPadding
};
var getTabListStyles = function getTabListStyles(mode) {
  return (
    // eslint-disable-next-line @repo/internal/styles/no-exported-styles
    (0, _react.css)({
      '& [role="tab"]': getTabStyles(mode),
      fontWeight: "var(--ds-font-weight-medium, 500)",
      '&::before': _objectSpread(_objectSpread({}, tabLineStyles), {}, {
        height: underlineHeight,
        // This line is not a border so the selected line is visible in high contrast mode
        backgroundColor: (0, _colors.getTabLineColor)(mode).lineColor
      })
    })
  );
};
exports.getTabListStyles = getTabListStyles;
var tabPanelFocusStyles = function tabPanelFocusStyles(mode) {
  var colors = (0, _colors.getTabColors)(mode);
  return {
    boxShadow: "0 0 0 2px ".concat(colors.focusBorderColor, " inset"),
    borderRadius: "var(--ds-border-radius, 3px)",
    outline: 'none',
    // Hide TabLine on focus
    '&::after': {
      opacity: 0
    }
  };
};
var getTabStyles = function getTabStyles(mode) {
  var colors = (0, _colors.getTabColors)(mode);
  return _objectSpread(_objectSpread({
    color: colors.labelColor,
    cursor: 'pointer',
    lineHeight: 1.8,
    margin: 0,
    padding: "".concat(tabTopBottomPadding, " ").concat(tabLeftRightPadding),
    position: 'relative',
    whiteSpace: 'nowrap',
    overflow: 'hidden',
    textOverflow: 'ellipsis',
    '&:hover': {
      // TODO: interaction states will be reviewed in DSP-1438
      color: colors.hoverLabelColor,
      '&::after': _objectSpread(_objectSpread({}, tabLineStyles), {}, {
        borderBottom: "".concat(underlineHeight, " solid ").concat((0, _colors.getTabLineColor)(mode).hoveredColor),
        height: 0
      })
    },
    '&:active': {
      // TODO: interaction states will be reviewed in DSP-1438
      color: colors.activeLabelColor,
      '&::after': _objectSpread(_objectSpread({}, tabLineStyles), {}, {
        borderBottom: "".concat(underlineHeight, " solid ").concat((0, _colors.getTabLineColor)(mode).activeColor),
        height: 0
      })
    },
    '&:focus-visible': tabPanelFocusStyles(mode),
    '@supports not selector(*:focus-visible)': {
      '&:focus': tabPanelFocusStyles(mode)
    }
  }, highContrastFocusRing), {}, {
    '&[aria-selected="true"]': {
      color: colors.selectedColor,
      '&::after': _objectSpread(_objectSpread({}, tabLineStyles), {}, {
        // This line is a border so it is visible in high contrast mode
        borderBottom: "".concat(underlineHeight, " solid ").concat((0, _colors.getTabLineColor)(mode).selectedColor),
        height: 0
      })
    }
  });
};
exports.getTabStyles = getTabStyles;