import _extends from "@babel/runtime/helpers/extends";
/** @jsx jsx */
import { Fragment } from 'react';
import { jsx } from '@emotion/react';
import { UNSAFE_Box as Box } from '@atlaskit/ds-explorations';
import { useTabPanel } from '../hooks';
// Note this is not being memoized as children is an unstable reference
/**
 * __TabPanel__
 *
 * A TabPanel houses the contents of a Tab.
 *
 * - [Examples](https://atlassian.design/components/tabs/examples)
 * - [Code](https://atlassian.design/components/tabs/code)
 * - [Usage](https://atlassian.design/components/tabs/usage)
 */
const TabPanel = ({
  children,
  testId
}) => {
  const tabPanelAttributes = useTabPanel();
  return jsx(Box, _extends({
    testId: testId,
    as: "div"
  }, tabPanelAttributes), jsx(Fragment, null, children));
};
export default TabPanel;