import _extends from "@babel/runtime/helpers/extends";
/** @jsx jsx */
import { jsx } from '@emotion/react';
import { UNSAFE_Box as Box, UNSAFE_Text as Text } from '@atlaskit/ds-explorations';
import { useTab } from '../hooks';
/**
 * __Tab__
 *
 * Tab represents an indivudal Tab displayed in a TabList.
 *
 * - [Examples](https://atlassian.design/components/tabs/examples)
 * - [Code](https://atlassian.design/components/tabs/code)
 * - [Usage](https://atlassian.design/components/tabs/usage)
 */
export default function Tab({
  children,
  testId
}) {
  const tabAttributes = useTab();
  return jsx(Box, _extends({
    as: "div",
    testId: testId
  }, tabAttributes), jsx(Text, {
    shouldTruncate: true,
    UNSAFE_style: {
      color: 'inherit'
    }
  }, children));
}