import { B100, B200, B400, B500, B75, DN0, DN400, N30, N500 } from '@atlaskit/theme/colors';
const tabColorMap = {
  light: {
    labelColor: `var(--ds-text-subtle, ${N500})`,
    activeLabelColor: `var(--ds-text, ${B500})`,
    hoverLabelColor: `var(--ds-text-subtle, ${B400})`,
    selectedColor: `var(--ds-text-selected, ${B400})`,
    focusBorderColor: `var(--ds-border-focused, ${B100})`
  },
  dark: {
    labelColor: `var(--ds-text-subtle, ${DN400})`,
    activeLabelColor: `var(--ds-text, ${B200})`,
    hoverLabelColor: `var(--ds-text-subtle, ${B75})`,
    selectedColor: `var(--ds-text-selected, ${B75})`,
    focusBorderColor: `var(--ds-border-focused, ${B75})`
  }
};
export const getTabColors = mode => {
  return tabColorMap[mode];
};
const tabLineColorMap = {
  light: {
    lineColor: `var(--ds-border, ${N30})`,
    hoveredColor: "var(--ds-border, transparent)",
    activeColor: "var(--ds-border, transparent)",
    selectedColor: `var(--ds-border-selected, ${B400})`
  },
  dark: {
    lineColor: `var(--ds-border, ${DN0})`,
    hoveredColor: "var(--ds-border, transparent)",
    activeColor: "var(--ds-border, transparent)",
    selectedColor: `var(--ds-border-selected, ${B75})`
  }
};
export const getTabLineColor = mode => tabLineColorMap[mode];
const tabPanelFocusColorMap = {
  light: `var(--ds-border-focused, ${B100})`,
  dark: `var(--ds-border-focused, ${B75})`
};
export const getTabPanelFocusColor = mode => tabPanelFocusColorMap[mode];