import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _toArray from "@babel/runtime/helpers/toArray";
import _slicedToArray from "@babel/runtime/helpers/slicedToArray";
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }
/** @jsx jsx */
import { Children, Fragment, useCallback, useMemo, useRef, useState } from 'react';
import { jsx } from '@emotion/react';
import { usePlatformLeafEventHandler } from '@atlaskit/analytics-next/usePlatformLeafEventHandler';
import { UNSAFE_Box as Box } from '@atlaskit/ds-explorations';
import { useGlobalTheme } from '@atlaskit/theme/components';
import { TabListContext, TabPanelContext } from '../internal/context';
import { getTabsStyles } from '../internal/styles';
import { onMouseDownBlur } from '../internal/utils';
var analyticsAttributes = {
  componentName: 'tabs',
  packageName: "@atlaskit/tabs",
  packageVersion: "13.4.3"
};
var getTabPanelWithContext = function getTabPanelWithContext(_ref) {
  var tabPanel = _ref.tabPanel,
    index = _ref.index,
    isSelected = _ref.isSelected,
    tabsId = _ref.tabsId;
  return (
    // Ensure tabPanel exists in case it has been removed
    tabPanel && jsx(TabPanelContext.Provider, {
      value: {
        role: 'tabpanel',
        id: "".concat(tabsId, "-").concat(index, "-tab"),
        hidden: isSelected ? undefined : true,
        'aria-labelledby': "".concat(tabsId, "-").concat(index),
        onMouseDown: onMouseDownBlur,
        tabIndex: isSelected ? 0 : -1
      },
      key: index
    }, tabPanel)
  );
};

/**
 * __Tabs__
 *
 * Tabs acts as a container for all Tab components.
 *
 * - [Examples](https://atlassian.design/components/tabs/examples)
 * - [Code](https://atlassian.design/components/tabs/code)
 * - [Usage](https://atlassian.design/components/tabs/usage)
 */
var Tabs = function Tabs(props) {
  var _props$shouldUnmountT = props.shouldUnmountTabPanelOnChange,
    shouldUnmountTabPanelOnChange = _props$shouldUnmountT === void 0 ? false : _props$shouldUnmountT,
    SelectedType = props.selected,
    defaultSelected = props.defaultSelected,
    onChangeProp = props.onChange,
    id = props.id,
    analyticsContext = props.analyticsContext,
    children = props.children,
    testId = props.testId;
  var _useGlobalTheme = useGlobalTheme(),
    mode = _useGlobalTheme.mode;
  var _useState = useState(SelectedType || defaultSelected || 0),
    _useState2 = _slicedToArray(_useState, 2),
    selectedState = _useState2[0],
    setSelected = _useState2[1];
  var selected = SelectedType === undefined ? selectedState : SelectedType;
  var childrenArray = Children.toArray(children)
  // Don't include any conditional children
  .filter(function (child) {
    return Boolean(child);
  });
  // First child should be a tabList followed by tab panels
  var _childrenArray = _toArray(childrenArray),
    tabList = _childrenArray[0],
    tabPanels = _childrenArray.slice(1);

  // Keep track of visited and add to a set
  var visited = useRef(new Set([selected]));
  if (!visited.current.has(selected)) {
    visited.current.add(selected);
  }
  var onChange = useCallback(function (index, analyticsEvent) {
    if (onChangeProp) {
      onChangeProp(index, analyticsEvent);
    }
    setSelected(index);
  }, [onChangeProp]);
  var onChangeAnalytics = usePlatformLeafEventHandler(_objectSpread({
    fn: onChange,
    action: 'clicked',
    analyticsData: analyticsContext
  }, analyticsAttributes));
  var tabPanelsWithContext = shouldUnmountTabPanelOnChange ? getTabPanelWithContext({
    tabPanel: tabPanels[selected],
    index: selected,
    isSelected: true,
    tabsId: id
  }) :
  // If a panel has already been visited, don't unmount it
  Array.from(visited.current).map(function (tabIndex) {
    return getTabPanelWithContext({
      tabPanel: tabPanels[tabIndex],
      index: tabIndex,
      isSelected: tabIndex === selected,
      tabsId: id
    });
  });
  var tabsStyles = useMemo(function () {
    return getTabsStyles(mode);
  }, [mode]);
  return (
    // Only styles that affect the Tabs container itself have been applied via primitives.
    // The other styles applied through the CSS prop are there for styling children
    // through inheritance. This is important for custom cases that use the useTabPanel(),
    // which applies accessibility atributes that we use as a styling hook.
    jsx(Box, {
      as: "div",
      testId: testId,
      display: "flex",
      flexDirection: "column",
      UNSAFE_style: {
        maxWidth: '100%',
        minHeight: '0%',
        flexBasis: '100%',
        flexGrow: 1
      }
      // eslint-disable-next-line @atlaskit/design-system/consistent-css-prop-usage
      ,
      css: tabsStyles
    }, jsx(TabListContext.Provider, {
      value: {
        selected: selected,
        onChange: onChangeAnalytics,
        tabsId: id
      }
    }, tabList), jsx(Fragment, null, tabPanelsWithContext))
  );
};
export default Tabs;