import { B100, B200, B400, B500, B75, DN0, DN400, N30, N500 } from '@atlaskit/theme/colors';
var tabColorMap = {
  light: {
    labelColor: "var(--ds-text-subtle, ".concat(N500, ")"),
    activeLabelColor: "var(--ds-text, ".concat(B500, ")"),
    hoverLabelColor: "var(--ds-text-subtle, ".concat(B400, ")"),
    selectedColor: "var(--ds-text-selected, ".concat(B400, ")"),
    focusBorderColor: "var(--ds-border-focused, ".concat(B100, ")")
  },
  dark: {
    labelColor: "var(--ds-text-subtle, ".concat(DN400, ")"),
    activeLabelColor: "var(--ds-text, ".concat(B200, ")"),
    hoverLabelColor: "var(--ds-text-subtle, ".concat(B75, ")"),
    selectedColor: "var(--ds-text-selected, ".concat(B75, ")"),
    focusBorderColor: "var(--ds-border-focused, ".concat(B75, ")")
  }
};
export var getTabColors = function getTabColors(mode) {
  return tabColorMap[mode];
};
var tabLineColorMap = {
  light: {
    lineColor: "var(--ds-border, ".concat(N30, ")"),
    hoveredColor: "var(--ds-border, transparent)",
    activeColor: "var(--ds-border, transparent)",
    selectedColor: "var(--ds-border-selected, ".concat(B400, ")")
  },
  dark: {
    lineColor: "var(--ds-border, ".concat(DN0, ")"),
    hoveredColor: "var(--ds-border, transparent)",
    activeColor: "var(--ds-border, transparent)",
    selectedColor: "var(--ds-border-selected, ".concat(B75, ")")
  }
};
export var getTabLineColor = function getTabLineColor(mode) {
  return tabLineColorMap[mode];
};
var tabPanelFocusColorMap = {
  light: "var(--ds-border-focused, ".concat(B100, ")"),
  dark: "var(--ds-border-focused, ".concat(B75, ")")
};
export var getTabPanelFocusColor = function getTabPanelFocusColor(mode) {
  return tabPanelFocusColorMap[mode];
};