"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.transparent = exports.textColor = exports.subtleBorderColorHover = exports.placeholderTextColor = exports.invalidBorderColor = exports.disabledTextColor = exports.disabledBorder = exports.disabledBackground = exports.defaultBorderColorFocus = exports.defaultBorderColor = exports.defaultBackgroundColorHover = exports.defaultBackgroundColorFocus = exports.defaultBackgroundColor = void 0;
var _platformFeatureFlags = require("@atlaskit/platform-feature-flags");
var _colors = require("@atlaskit/theme/colors");
var disabledBackground = {
  light: "var(--ds-background-disabled, ".concat(_colors.N20, ")"),
  dark: "var(--ds-background-disabled, ".concat(_colors.DN20, ")")
};
exports.disabledBackground = disabledBackground;
var disabledBorder = {
  light: "var(--ds-border-disabled, ".concat(_colors.N40, ")"),
  dark: "var(--ds-border-disabled, ".concat(_colors.DN40, ")")
};
exports.disabledBorder = disabledBorder;
var invalidBorderColor = {
  light: "var(--ds-border-danger, ".concat(_colors.R400, ")"),
  dark: "var(--ds-border-danger, ".concat(_colors.R400, ")")
};
exports.invalidBorderColor = invalidBorderColor;
var defaultBorderColor = {
  light: "var(--ds-border-input, ".concat((0, _platformFeatureFlags.getBooleanFF)('platform.design-system-team.border-checkbox_nyoiu') ? _colors.N100 : _colors.N40, ")"),
  dark: "var(--ds-border-input, ".concat((0, _platformFeatureFlags.getBooleanFF)('platform.design-system-team.border-checkbox_nyoiu') ? _colors.DN200 : _colors.DN40, ")")
};
exports.defaultBorderColor = defaultBorderColor;
var defaultBorderColorFocus = {
  light: "var(--ds-border-focused, ".concat(_colors.B100, ")"),
  dark: "var(--ds-border-focused, ".concat(_colors.B75, ")")
};
exports.defaultBorderColorFocus = defaultBorderColorFocus;
var defaultBackgroundColor = {
  light: "var(--ds-background-input, ".concat(_colors.N10, ")"),
  dark: "var(--ds-background-input, ".concat(_colors.DN10, ")")
};
exports.defaultBackgroundColor = defaultBackgroundColor;
var defaultBackgroundColorHover = {
  light: "var(--ds-background-input-hovered, ".concat(_colors.N30, ")"),
  dark: "var(--ds-background-input-hovered, ".concat(_colors.DN30, ")")
};
exports.defaultBackgroundColorHover = defaultBackgroundColorHover;
var defaultBackgroundColorFocus = {
  light: "var(--ds-background-input-pressed, ".concat(_colors.N0, ")"),
  dark: "var(--ds-background-input-pressed, ".concat(_colors.DN10, ")")
};
exports.defaultBackgroundColorFocus = defaultBackgroundColorFocus;
var subtleBorderColorHover = {
  light: "var(--ds-border-input, transparent)",
  dark: "var(--ds-border-input, transparent)"
};
exports.subtleBorderColorHover = subtleBorderColorHover;
var placeholderTextColor = {
  light: "var(--ds-text-subtlest, ".concat(_colors.N200, ")"),
  dark: "var(--ds-text-subtlest, ".concat(_colors.DN200, ")")
};
exports.placeholderTextColor = placeholderTextColor;
var textColor = {
  light: "var(--ds-text, ".concat(_colors.N900, ")"),
  dark: "var(--ds-text, ".concat(_colors.DN600, ")")
};
exports.textColor = textColor;
var disabledTextColor = {
  light: "var(--ds-text-disabled, ".concat(_colors.N70, ")"),
  dark: "var(--ds-text-disabled, ".concat(_colors.DN90, ")")
};
exports.disabledTextColor = disabledTextColor;
var transparent = {
  light: 'transparent',
  dark: 'transparent'
};
exports.transparent = transparent;