"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.themeStyles = exports.getBaseStyles = exports.borderWidth = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = require("@emotion/react");
var _platformFeatureFlags = require("@atlaskit/platform-feature-flags");
var _constants = require("@atlaskit/theme/constants");
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { (0, _defineProperty2.default)(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; } /** @jsx jsx */
var grid = (0, _constants.gridSize)();
var lineHeightBase = grid * 2.5;
var lineHeightCompact = grid * 2;
var compactVerticalPadding = 2;
var verticalPadding = 6;
var horizontalPadding = grid;
var transitionDuration = '0.2s';
var fontSize = (0, _constants.fontSize)();
var fontFamily = (0, _constants.fontFamily)();
var codeFontFamily = (0, _constants.codeFontFamily)();
var borderWidth = 2;

// Safari puts on some difficult to remove styles, mainly for disabled inputs
// but we want full control so need to override them in all cases
exports.borderWidth = borderWidth;
var overrideSafariDisabledStyles = {
  WebkitTextFillColor: 'unset',
  WebkitOpacity: '1'
};
var borderBoxMinHeight = function borderBoxMinHeight(minimumRows, borderHeight) {
  var contentHeight = lineHeightBase * minimumRows;
  return contentHeight + verticalPadding * 2 + borderHeight * 2;
};
var borderBoxMinHeightCompact = function borderBoxMinHeightCompact(minimumRows, borderHeight) {
  var contentHeightCompact = lineHeightCompact * minimumRows;
  return contentHeightCompact + compactVerticalPadding * 2 + borderHeight * 2;
};
var bgAndBorderColorStyles = function bgAndBorderColorStyles(props, appearance) {
  return (0, _react.css)(_objectSpread({
    '&:focus': {
      backgroundColor: props.backgroundColorFocus,
      borderColor: props.borderColorFocus,
      boxShadow: (0, _platformFeatureFlags.getBooleanFF)('platform.design-system-team.border-checkbox_nyoiu') ? "inset 0 0 0 ".concat("var(--ds-border-width, 1px)", " ", props.borderColorFocus) : undefined
    },
    '&:not(:focus)': {
      backgroundColor: props.backgroundColor,
      borderColor: props.borderColor
    },
    // eslint-disable-next-line @repo/internal/styles/no-nested-styles
    '&[data-invalid]:focus': {
      backgroundColor: props.invalidRules.backgroundColorFocus,
      borderColor: props.invalidRules.borderColorFocus,
      boxShadow: (0, _platformFeatureFlags.getBooleanFF)('platform.design-system-team.border-checkbox_nyoiu') ? "inset 0 0 0 ".concat("var(--ds-border-width, 1px)", " ", props.invalidRules.borderColorFocus) : undefined
    },
    // eslint-disable-next-line @repo/internal/styles/no-nested-styles
    '&[data-invalid]:not(:focus)': {
      backgroundColor: props.invalidRules.backgroundColor,
      borderColor: props.invalidRules.borderColor,
      boxShadow: (0, _platformFeatureFlags.getBooleanFF)('platform.design-system-team.border-checkbox_nyoiu') ? "inset 0 0 0 ".concat("var(--ds-border-width, 1px)", " ", props.invalidRules.borderColor) : undefined
    }
  }, appearance === 'standard' ? {
    '&:disabled:focus': {
      backgroundColor: props.disabledRules.backgroundColorFocus,
      borderColor: props.disabledRules.borderColorFocus
    },
    '&:disabled:not(:focus)': {
      backgroundColor: props.disabledRules.backgroundColor,
      borderColor: props.disabledRules.borderColor
    }
  } : {}));
};
var placeholderStyle = function placeholderStyle(placeholderTextColor) {
  return (0, _react.css)({
    '&::placeholder': {
      color: placeholderTextColor
    }
  });
};
var hoverBackgroundAndBorderStyles = function hoverBackgroundAndBorderStyles(props) {
  return (0, _react.css)({
    '&:hover:not(:read-only):not(:focus)': {
      backgroundColor: props.backgroundColorHover,
      borderColor: props.borderColorHover,
      '&:disabled': {
        backgroundColor: props.disabledRules.backgroundColorHover
      },
      // eslint-disable-next-line @repo/internal/styles/no-nested-styles
      '&[data-invalid]': {
        backgroundColor: props.invalidRules.backgroundColorHover,
        borderColor: props.invalidRules.borderColor,
        boxShadow: (0, _platformFeatureFlags.getBooleanFF)('platform.design-system-team.border-checkbox_nyoiu') ? "inset 0 0 0 ".concat("var(--ds-border-width, 1px)", " ", props.invalidRules.borderColor) : undefined
      }
    }
  });
};
var resizeStyle = function resizeStyle(resize) {
  if (resize === 'horizontal' || resize === 'vertical') {
    return (0, _react.css)({
      resize: resize
    });
  }
  if (resize === 'auto') {
    return (0, _react.css)({
      resize: 'both'
    });
  }
  return (0, _react.css)({
    resize: 'none'
  });
};
var borderStyle = function borderStyle(appearance) {
  return (0, _react.css)({
    borderStyle: appearance === 'none' ? 'none' : 'solid'
  });
};
var fontFamilyStyle = function fontFamilyStyle(isMonospaced) {
  return (0, _react.css)({
    fontFamily: isMonospaced ? codeFontFamily : fontFamily
  });
};
var borderPaddingAndHeightStyles = function borderPaddingAndHeightStyles() {
  var minimumRows = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 1;
  var appearance = arguments.length > 1 ? arguments[1] : undefined;
  var borderWidth = (0, _platformFeatureFlags.getBooleanFF)('platform.design-system-team.border-checkbox_nyoiu') && appearance !== 'none' ? 1 : 2;
  var horizontalPaddingWithoutBorderWidth = horizontalPadding - borderWidth;
  var borderHeight = borderWidth;
  return (0, _react.css)({
    // eslint-disable-next-line @repo/internal/styles/no-nested-styles
    '&[data-compact]': {
      minHeight: borderBoxMinHeightCompact(minimumRows, borderHeight),
      // eslint-disable-next-line @atlaskit/design-system/ensure-design-token-usage
      padding: "".concat(compactVerticalPadding, "px ").concat(horizontalPaddingWithoutBorderWidth, "px"),
      lineHeight: lineHeightCompact / fontSize
    },
    '&:not([data-compact])': {
      minHeight: borderBoxMinHeight(minimumRows, borderHeight),
      // eslint-disable-next-line @atlaskit/design-system/ensure-design-token-usage
      padding: "".concat(verticalPadding, "px ").concat(horizontalPaddingWithoutBorderWidth, "px"),
      lineHeight: lineHeightBase / fontSize
    }
  });
};
var staticStyles = (0, _react.css)({
  display: 'block',
  boxSizing: 'border-box',
  width: '100%',
  minWidth: 0,
  maxWidth: '100%',
  margin: 0,
  position: 'relative',
  flex: '1 1 100%',
  borderRadius: "var(--ds-border-radius, 3px)",
  // eslint-disable-next-line @atlaskit/design-system/ensure-design-token-usage
  borderWidth: (0, _platformFeatureFlags.getBooleanFF)('platform.design-system-team.border-checkbox_nyoiu') ? 1 : borderWidth,
  fontSize: fontSize,
  outline: 'none',
  overflow: 'auto',
  transition: "background-color ".concat(transitionDuration, " ease-in-out,\n               border-color ").concat(transitionDuration, " ease-in-out"),
  wordWrap: 'break-word',
  '&:disabled': _objectSpread({
    cursor: 'not-allowed'
  }, overrideSafariDisabledStyles),
  '&::-ms-clear': {
    display: 'none'
  },
  '&:invalid': {
    boxShadow: 'none'
  }
});
var getBaseStyles = function getBaseStyles(_ref) {
  var minimumRows = _ref.minimumRows,
    resize = _ref.resize,
    appearance = _ref.appearance,
    isMonospaced = _ref.isMonospaced,
    maxHeight = _ref.maxHeight;
  return (
    // eslint-disable-next-line @repo/internal/styles/no-exported-styles
    (0, _react.css)([staticStyles, borderPaddingAndHeightStyles(minimumRows, appearance), resizeStyle(resize), borderStyle(appearance), fontFamilyStyle(isMonospaced), {
      maxHeight: maxHeight
    }])
  );
};
exports.getBaseStyles = getBaseStyles;
var themeStyles = function themeStyles(props, appearance) {
  return (
    // eslint-disable-next-line @repo/internal/styles/no-exported-styles
    (0, _react.css)([bgAndBorderColorStyles(props, appearance), hoverBackgroundAndBorderStyles(props), placeholderStyle(props.placeholderTextColor), {
      color: props.textColor,
      '&:disabled': {
        color: props.disabledRules.textColor
      }
    }])
  );
};
exports.themeStyles = themeStyles;