"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof3 = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _typeof2 = _interopRequireDefault(require("@babel/runtime/helpers/typeof"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _analyticsNext = require("@atlaskit/analytics-next");
var _components = require("@atlaskit/theme/components");
var _styles = require("./styles");
var _theme = require("./theme");
var _excluded = ["resize", "appearance", "isCompact", "isRequired", "isReadOnly", "isDisabled", "isInvalid", "isMonospaced", "minimumRows", "theme", "testId", "maxHeight", "onBlur", "onFocus", "onChange", "tokens", "value"];
/** @jsx jsx */
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof3(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { (0, _defineProperty2.default)(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }
var packageName = "@atlaskit/textarea";
var packageVersion = "4.7.4";
var analyticsParams = {
  componentName: 'textArea',
  packageName: packageName,
  packageVersion: packageVersion
};
var setSmartHeight = function setSmartHeight(el) {
  // Always reset height to auto before calculating new height
  el.style.height = 'auto';
  var borderHeight = _styles.borderWidth;
  var paddingBoxHeight = el.scrollHeight;
  var borderBoxHeight = paddingBoxHeight + borderHeight * 2;
  el.style.height = "".concat(borderBoxHeight, "px");
};
var TextAreaWithTokens = /*#__PURE__*/(0, _react.forwardRef)(function (props, ref) {
  var ourRef = (0, _react.useRef)(null);
  var _props$resize = props.resize,
    resize = _props$resize === void 0 ? 'smart' : _props$resize,
    _props$appearance = props.appearance,
    appearance = _props$appearance === void 0 ? 'standard' : _props$appearance,
    _props$isCompact = props.isCompact,
    isCompact = _props$isCompact === void 0 ? false : _props$isCompact,
    _props$isRequired = props.isRequired,
    isRequired = _props$isRequired === void 0 ? false : _props$isRequired,
    _props$isReadOnly = props.isReadOnly,
    isReadOnly = _props$isReadOnly === void 0 ? false : _props$isReadOnly,
    _props$isDisabled = props.isDisabled,
    isDisabled = _props$isDisabled === void 0 ? false : _props$isDisabled,
    _props$isInvalid = props.isInvalid,
    isInvalid = _props$isInvalid === void 0 ? false : _props$isInvalid,
    _props$isMonospaced = props.isMonospaced,
    isMonospaced = _props$isMonospaced === void 0 ? false : _props$isMonospaced,
    _props$minimumRows = props.minimumRows,
    minimumRows = _props$minimumRows === void 0 ? 2 : _props$minimumRows,
    theme = props.theme,
    testId = props.testId,
    _props$maxHeight = props.maxHeight,
    maxHeight = _props$maxHeight === void 0 ? '50vh' : _props$maxHeight,
    onBlur = props.onBlur,
    onFocus = props.onFocus,
    onChange = props.onChange,
    tokens = props.tokens,
    value = props.value,
    rest = (0, _objectWithoutProperties2.default)(props, _excluded);
  (0, _react.useEffect)(function () {
    var el = ourRef.current;
    if (resize === 'smart' && el) {
      setSmartHeight(el);
    }
  }, [resize, value]);
  var onBlurWithAnalytics = (0, _analyticsNext.usePlatformLeafEventHandler)(_objectSpread({
    fn: function fn(event) {
      onBlur && onBlur(event);
    },
    action: 'blurred'
  }, analyticsParams));
  var onFocusWithAnalytics = (0, _analyticsNext.usePlatformLeafEventHandler)(_objectSpread({
    fn: function fn(event) {
      onFocus && onFocus(event);
    },
    action: 'focused'
  }, analyticsParams));
  var getTextAreaRef = function getTextAreaRef(elementRef) {
    ourRef.current = elementRef;
    if (ref && (0, _typeof2.default)(ref) === 'object') {
      // @ts-ignore
      ref.current = elementRef;
    }
    if (ref && typeof ref === 'function') {
      ref(elementRef);
    }
  };
  var handleOnChange = (0, _react.useCallback)(function (e) {
    var el = ourRef.current;
    if (resize === 'smart' && el) {
      setSmartHeight(el);
    }
    onChange && onChange(e);
  }, [onChange, resize]);
  var controlProps = {
    'data-invalid': isInvalid ? isInvalid : undefined,
    'data-compact': isCompact ? isCompact : undefined,
    'data-testid': testId ? testId : undefined
  };
  var baseStyles = (0, _react.useMemo)(function () {
    return (0, _styles.getBaseStyles)({
      minimumRows: minimumRows,
      resize: resize,
      appearance: appearance,
      isMonospaced: isMonospaced,
      maxHeight: maxHeight
    });
  }, [minimumRows, resize, appearance, isMonospaced, maxHeight]);
  var textAreaStyles = (0, _react2.css)([baseStyles,
  // not memoizing themeStyles as `tokens` is an unstable reference
  (0, _styles.themeStyles)(tokens, appearance)]);
  return (0, _react2.jsx)("textarea", (0, _extends2.default)({}, controlProps, {
    value: value,
    disabled: isDisabled,
    readOnly: isReadOnly,
    required: isRequired,
    ref: getTextAreaRef,
    onChange: handleOnChange,
    onBlur: onBlurWithAnalytics,
    onFocus: onFocusWithAnalytics,
    rows: minimumRows
    // TODO refactor to follow emotion styling rules
    // see: https://product-fabric.atlassian.net/browse/DSP-6060
    // eslint-disable-next-line @atlaskit/design-system/consistent-css-prop-usage
    ,
    css: textAreaStyles
  }, rest));
});

/**
 * __Text area__
 *
 * A text area lets users enter long form text which spans over multiple lines.
 *
 * - [Examples](https://atlassian.design/components/textarea/examples)
 * - [Code](https://atlassian.design/components/textarea/code)
 * - [Usage](https://atlassian.design/components/textarea/usage)
 */
var TextArea = /*#__PURE__*/(0, _react.memo)( /*#__PURE__*/(0, _react.forwardRef)(function TextArea(props, ref) {
  var _useGlobalTheme = (0, _components.useGlobalTheme)(),
    mode = _useGlobalTheme.mode;
  return (0, _react2.jsx)(_theme.Theme.Provider, {
    value: props.theme
  }, (0, _react2.jsx)(_theme.Theme.Consumer, {
    appearance: props.appearance || 'standard',
    mode: mode
  }, function (tokens) {
    return (0, _react2.jsx)(TextAreaWithTokens, (0, _extends2.default)({
      ref: ref
    }, props, {
      tokens: tokens
    }));
  }));
}));
TextArea.displayName = 'TextArea';
var _default = TextArea;
exports.default = _default;