import { getBooleanFF } from '@atlaskit/platform-feature-flags';
import { B100, B75, DN10, DN20, DN200, DN30, DN40, DN600, DN90, N0, N10, N100, N20, N200, N30, N40, N70, N900, R400 } from '@atlaskit/theme/colors';
export const disabledBackground = {
  light: `var(--ds-background-disabled, ${N20})`,
  dark: `var(--ds-background-disabled, ${DN20})`
};
export const disabledBorder = {
  light: `var(--ds-border-disabled, ${N40})`,
  dark: `var(--ds-border-disabled, ${DN40})`
};
export const invalidBorderColor = {
  light: `var(--ds-border-danger, ${R400})`,
  dark: `var(--ds-border-danger, ${R400})`
};
export const defaultBorderColor = {
  light: `var(--ds-border-input, ${getBooleanFF('platform.design-system-team.border-checkbox_nyoiu') ? N100 : N40})`,
  dark: `var(--ds-border-input, ${getBooleanFF('platform.design-system-team.border-checkbox_nyoiu') ? DN200 : DN40})`
};
export const defaultBorderColorFocus = {
  light: `var(--ds-border-focused, ${B100})`,
  dark: `var(--ds-border-focused, ${B75})`
};
export const defaultBackgroundColor = {
  light: `var(--ds-background-input, ${N10})`,
  dark: `var(--ds-background-input, ${DN10})`
};
export const defaultBackgroundColorHover = {
  light: `var(--ds-background-input-hovered, ${N30})`,
  dark: `var(--ds-background-input-hovered, ${DN30})`
};
export const defaultBackgroundColorFocus = {
  light: `var(--ds-background-input-pressed, ${N0})`,
  dark: `var(--ds-background-input-pressed, ${DN10})`
};
export const subtleBorderColorHover = {
  light: "var(--ds-border-input, transparent)",
  dark: "var(--ds-border-input, transparent)"
};
export const placeholderTextColor = {
  light: `var(--ds-text-subtlest, ${N200})`,
  dark: `var(--ds-text-subtlest, ${DN200})`
};
export const textColor = {
  light: `var(--ds-text, ${N900})`,
  dark: `var(--ds-text, ${DN600})`
};
export const disabledTextColor = {
  light: `var(--ds-text-disabled, ${N70})`,
  dark: `var(--ds-text-disabled, ${DN90})`
};
export const transparent = {
  light: 'transparent',
  dark: 'transparent'
};