import _extends from "@babel/runtime/helpers/extends";
import _typeof from "@babel/runtime/helpers/typeof";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["resize", "appearance", "isCompact", "isRequired", "isReadOnly", "isDisabled", "isInvalid", "isMonospaced", "minimumRows", "theme", "testId", "maxHeight", "onBlur", "onFocus", "onChange", "tokens", "value"];
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }
/** @jsx jsx */
import React, { forwardRef, memo, useCallback, useEffect, useMemo, useRef } from 'react';
import { css, jsx } from '@emotion/react';
import { usePlatformLeafEventHandler } from '@atlaskit/analytics-next';
import { useGlobalTheme } from '@atlaskit/theme/components';
import { borderWidth, getBaseStyles, themeStyles } from './styles';
import { Theme } from './theme';
var packageName = "@atlaskit/textarea";
var packageVersion = "4.7.4";
var analyticsParams = {
  componentName: 'textArea',
  packageName: packageName,
  packageVersion: packageVersion
};
var setSmartHeight = function setSmartHeight(el) {
  // Always reset height to auto before calculating new height
  el.style.height = 'auto';
  var borderHeight = borderWidth;
  var paddingBoxHeight = el.scrollHeight;
  var borderBoxHeight = paddingBoxHeight + borderHeight * 2;
  el.style.height = "".concat(borderBoxHeight, "px");
};
var TextAreaWithTokens = /*#__PURE__*/forwardRef(function (props, ref) {
  var ourRef = useRef(null);
  var _props$resize = props.resize,
    resize = _props$resize === void 0 ? 'smart' : _props$resize,
    _props$appearance = props.appearance,
    appearance = _props$appearance === void 0 ? 'standard' : _props$appearance,
    _props$isCompact = props.isCompact,
    isCompact = _props$isCompact === void 0 ? false : _props$isCompact,
    _props$isRequired = props.isRequired,
    isRequired = _props$isRequired === void 0 ? false : _props$isRequired,
    _props$isReadOnly = props.isReadOnly,
    isReadOnly = _props$isReadOnly === void 0 ? false : _props$isReadOnly,
    _props$isDisabled = props.isDisabled,
    isDisabled = _props$isDisabled === void 0 ? false : _props$isDisabled,
    _props$isInvalid = props.isInvalid,
    isInvalid = _props$isInvalid === void 0 ? false : _props$isInvalid,
    _props$isMonospaced = props.isMonospaced,
    isMonospaced = _props$isMonospaced === void 0 ? false : _props$isMonospaced,
    _props$minimumRows = props.minimumRows,
    minimumRows = _props$minimumRows === void 0 ? 2 : _props$minimumRows,
    theme = props.theme,
    testId = props.testId,
    _props$maxHeight = props.maxHeight,
    maxHeight = _props$maxHeight === void 0 ? '50vh' : _props$maxHeight,
    onBlur = props.onBlur,
    onFocus = props.onFocus,
    onChange = props.onChange,
    tokens = props.tokens,
    value = props.value,
    rest = _objectWithoutProperties(props, _excluded);
  useEffect(function () {
    var el = ourRef.current;
    if (resize === 'smart' && el) {
      setSmartHeight(el);
    }
  }, [resize, value]);
  var onBlurWithAnalytics = usePlatformLeafEventHandler(_objectSpread({
    fn: function fn(event) {
      onBlur && onBlur(event);
    },
    action: 'blurred'
  }, analyticsParams));
  var onFocusWithAnalytics = usePlatformLeafEventHandler(_objectSpread({
    fn: function fn(event) {
      onFocus && onFocus(event);
    },
    action: 'focused'
  }, analyticsParams));
  var getTextAreaRef = function getTextAreaRef(elementRef) {
    ourRef.current = elementRef;
    if (ref && _typeof(ref) === 'object') {
      // @ts-ignore
      ref.current = elementRef;
    }
    if (ref && typeof ref === 'function') {
      ref(elementRef);
    }
  };
  var handleOnChange = useCallback(function (e) {
    var el = ourRef.current;
    if (resize === 'smart' && el) {
      setSmartHeight(el);
    }
    onChange && onChange(e);
  }, [onChange, resize]);
  var controlProps = {
    'data-invalid': isInvalid ? isInvalid : undefined,
    'data-compact': isCompact ? isCompact : undefined,
    'data-testid': testId ? testId : undefined
  };
  var baseStyles = useMemo(function () {
    return getBaseStyles({
      minimumRows: minimumRows,
      resize: resize,
      appearance: appearance,
      isMonospaced: isMonospaced,
      maxHeight: maxHeight
    });
  }, [minimumRows, resize, appearance, isMonospaced, maxHeight]);
  var textAreaStyles = css([baseStyles,
  // not memoizing themeStyles as `tokens` is an unstable reference
  themeStyles(tokens, appearance)]);
  return jsx("textarea", _extends({}, controlProps, {
    value: value,
    disabled: isDisabled,
    readOnly: isReadOnly,
    required: isRequired,
    ref: getTextAreaRef,
    onChange: handleOnChange,
    onBlur: onBlurWithAnalytics,
    onFocus: onFocusWithAnalytics,
    rows: minimumRows
    // TODO refactor to follow emotion styling rules
    // see: https://product-fabric.atlassian.net/browse/DSP-6060
    // eslint-disable-next-line @atlaskit/design-system/consistent-css-prop-usage
    ,
    css: textAreaStyles
  }, rest));
});

/**
 * __Text area__
 *
 * A text area lets users enter long form text which spans over multiple lines.
 *
 * - [Examples](https://atlassian.design/components/textarea/examples)
 * - [Code](https://atlassian.design/components/textarea/code)
 * - [Usage](https://atlassian.design/components/textarea/usage)
 */
var TextArea = /*#__PURE__*/memo( /*#__PURE__*/forwardRef(function TextArea(props, ref) {
  var _useGlobalTheme = useGlobalTheme(),
    mode = _useGlobalTheme.mode;
  return jsx(Theme.Provider, {
    value: props.theme
  }, jsx(Theme.Consumer, {
    appearance: props.appearance || 'standard',
    mode: mode
  }, function (tokens) {
    return jsx(TextAreaWithTokens, _extends({
      ref: ref
    }, props, {
      tokens: tokens
    }));
  }));
}));
TextArea.displayName = 'TextArea';
export default TextArea;