import { createTheme } from '@atlaskit/theme/components';
import * as componentTokens from './component-tokens';
var disabledRules = {
  light: {
    backgroundColor: componentTokens.disabledBackground.light,
    backgroundColorFocus: componentTokens.disabledBackground.light,
    backgroundColorHover: componentTokens.disabledBackground.light,
    borderColor: componentTokens.disabledBorder.light,
    borderColorFocus: componentTokens.defaultBorderColorFocus.light,
    textColor: componentTokens.disabledTextColor.light
  },
  dark: {
    backgroundColor: componentTokens.disabledBackground.dark,
    backgroundColorFocus: componentTokens.disabledBackground.dark,
    backgroundColorHover: componentTokens.disabledBackground.dark,
    borderColor: componentTokens.disabledBorder.dark,
    borderColorFocus: componentTokens.defaultBorderColorFocus.dark,
    textColor: componentTokens.disabledTextColor.dark
  }
};
var invalidRules = {
  light: {
    borderColor: componentTokens.invalidBorderColor.light,
    borderColorFocus: componentTokens.defaultBorderColorFocus.light,
    backgroundColor: componentTokens.defaultBackgroundColor.light,
    backgroundColorFocus: componentTokens.defaultBackgroundColorFocus.light,
    backgroundColorHover: componentTokens.defaultBackgroundColorHover.light
  },
  dark: {
    borderColor: componentTokens.invalidBorderColor.dark,
    borderColorFocus: componentTokens.defaultBorderColorFocus.dark,
    backgroundColor: componentTokens.defaultBackgroundColor.dark,
    backgroundColorFocus: componentTokens.defaultBackgroundColorFocus.dark,
    backgroundColorHover: componentTokens.defaultBackgroundColorHover.dark
  }
};
var backgroundColor = {
  standard: componentTokens.defaultBackgroundColor,
  subtle: componentTokens.transparent,
  none: componentTokens.transparent
};
var backgroundColorFocus = {
  standard: componentTokens.defaultBackgroundColorFocus,
  subtle: componentTokens.defaultBackgroundColorFocus,
  none: componentTokens.transparent
};
var backgroundColorHover = {
  standard: componentTokens.defaultBackgroundColorHover,
  subtle: componentTokens.defaultBackgroundColorHover,
  none: componentTokens.transparent
};
var borderColor = {
  standard: componentTokens.defaultBorderColor,
  subtle: componentTokens.transparent,
  none: componentTokens.transparent
};
var borderColorFocus = {
  standard: componentTokens.defaultBorderColorFocus,
  subtle: componentTokens.defaultBorderColorFocus,
  none: componentTokens.transparent
};
var borderColorHover = {
  standard: componentTokens.defaultBorderColor,
  subtle: componentTokens.subtleBorderColorHover,
  none: componentTokens.transparent
};

/**
 * @deprecated
 * Component-level theming is deprecated in the design system.
 * Components should respect the global theme.
 */

/**
 * @deprecated
 * Component-level theming is deprecated in the design system.
 * Components should respect the global theme.
 */
export var themeTokens = {
  borderColor: borderColor,
  borderColorFocus: borderColorFocus,
  backgroundColor: backgroundColor,
  backgroundColorFocus: backgroundColorFocus,
  backgroundColorHover: backgroundColorHover,
  disabledRules: disabledRules,
  invalidRules: invalidRules,
  textColor: componentTokens.textColor,
  placeholderTextColor: componentTokens.placeholderTextColor
};

/**
 * @deprecated
 * Component-level theming is deprecated in the design system.
 * Components should respect the global theme.
 */
export var Theme = createTheme(function (_ref) {
  var appearance = _ref.appearance,
    mode = _ref.mode;
  return {
    borderColor: borderColor[appearance][mode],
    borderColorFocus: borderColorFocus[appearance][mode],
    borderColorHover: borderColorHover[appearance][mode],
    backgroundColorHover: backgroundColorHover[appearance][mode],
    backgroundColorFocus: backgroundColorFocus[appearance][mode],
    backgroundColor: backgroundColor[appearance][mode],
    disabledRules: disabledRules[mode],
    invalidRules: invalidRules[mode],
    textColor: componentTokens.textColor[mode],
    placeholderTextColor: componentTokens.placeholderTextColor[mode]
  };
});