/// <reference types="react" />
export type ThemeAppearance = 'standard' | 'subtle' | 'none';
export type ThemeProps = {
    appearance: ThemeAppearance;
    /**
     * @deprecated
     * Mode is deprecated and will be deleted in the future.
     */
    mode: 'dark' | 'light';
};
/**
 * @deprecated
 * Component-level theming is deprecated in the design system.
 * Components should respect the global theme.
 */
export type ThemeTokens = {
    borderColor: string;
    borderColorFocus: string;
    borderColorHover: string;
    backgroundColor: string;
    backgroundColorFocus: string;
    backgroundColorHover: string;
    disabledRules: {
        backgroundColor: string;
        backgroundColorFocus: string;
        backgroundColorHover: string;
        borderColor: string;
        borderColorFocus: string;
        textColor: string;
    };
    invalidRules: {
        borderColor: string;
        borderColorFocus: string;
        backgroundColor: string;
        backgroundColorFocus: string;
        backgroundColorHover: string;
    };
    textColor: string;
    placeholderTextColor: string;
};
/**
 * @deprecated
 * Component-level theming is deprecated in the design system.
 * Components should respect the global theme.
 */
export declare const themeTokens: {
    borderColor: {
        standard: {
            light: "var(--ds-border-input)";
            dark: "var(--ds-border-input)";
        };
        subtle: {
            light: string;
            dark: string;
        };
        none: {
            light: string;
            dark: string;
        };
    };
    borderColorFocus: {
        standard: {
            light: "var(--ds-border-focused)";
            dark: "var(--ds-border-focused)";
        };
        subtle: {
            light: "var(--ds-border-focused)";
            dark: "var(--ds-border-focused)";
        };
        none: {
            light: string;
            dark: string;
        };
    };
    backgroundColor: {
        standard: {
            light: "var(--ds-background-input)";
            dark: "var(--ds-background-input)";
        };
        subtle: {
            light: string;
            dark: string;
        };
        none: {
            light: string;
            dark: string;
        };
    };
    backgroundColorFocus: {
        standard: {
            light: "var(--ds-background-input-pressed)";
            dark: "var(--ds-background-input-pressed)";
        };
        subtle: {
            light: "var(--ds-background-input-pressed)";
            dark: "var(--ds-background-input-pressed)";
        };
        none: {
            light: string;
            dark: string;
        };
    };
    backgroundColorHover: {
        standard: {
            light: "var(--ds-background-input-hovered)";
            dark: "var(--ds-background-input-hovered)";
        };
        subtle: {
            light: "var(--ds-background-input-hovered)";
            dark: "var(--ds-background-input-hovered)";
        };
        none: {
            light: string;
            dark: string;
        };
    };
    disabledRules: {
        light: {
            backgroundColor: "var(--ds-background-disabled)";
            backgroundColorFocus: "var(--ds-background-disabled)";
            backgroundColorHover: "var(--ds-background-disabled)";
            borderColor: "var(--ds-border-disabled)";
            borderColorFocus: "var(--ds-border-focused)";
            textColor: "var(--ds-text-disabled)";
        };
        dark: {
            backgroundColor: "var(--ds-background-disabled)";
            backgroundColorFocus: "var(--ds-background-disabled)";
            backgroundColorHover: "var(--ds-background-disabled)";
            borderColor: "var(--ds-border-disabled)";
            borderColorFocus: "var(--ds-border-focused)";
            textColor: "var(--ds-text-disabled)";
        };
    };
    invalidRules: {
        light: {
            borderColor: "var(--ds-border-danger)";
            borderColorFocus: "var(--ds-border-focused)";
            backgroundColor: "var(--ds-background-input)";
            backgroundColorFocus: "var(--ds-background-input-pressed)";
            backgroundColorHover: "var(--ds-background-input-hovered)";
        };
        dark: {
            borderColor: "var(--ds-border-danger)";
            borderColorFocus: "var(--ds-border-focused)";
            backgroundColor: "var(--ds-background-input)";
            backgroundColorFocus: "var(--ds-background-input-pressed)";
            backgroundColorHover: "var(--ds-background-input-hovered)";
        };
    };
    textColor: {
        light: "var(--ds-text)";
        dark: "var(--ds-text)";
    };
    placeholderTextColor: {
        light: "var(--ds-text-subtlest)";
        dark: "var(--ds-text-subtlest)";
    };
};
/**
 * @deprecated
 * Component-level theming is deprecated in the design system.
 * Components should respect the global theme.
 */
export declare const Theme: {
    Consumer: import("react").ComponentType<{
        children: (tokens: ThemeTokens) => import("react").ReactNode;
    } & ThemeProps>;
    Provider: import("react").ComponentType<{
        children?: import("react").ReactNode;
        value?: import("@atlaskit/theme/components").ThemeProp<ThemeTokens, ThemeProps> | undefined;
    }>;
    useTheme: (props: ThemeProps) => ThemeTokens;
};
