"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getColors = void 0;
var _colors = require("@atlaskit/theme/colors");
var colorMap = {
  light: {
    backgroundColorChecked: "var(--ds-background-success-bold, ".concat(_colors.G400, ")"),
    backgroundColorCheckedHover: "var(--ds-background-success-bold-hovered, ".concat(_colors.G500, ")"),
    backgroundColorCheckedDisabled: "var(--ds-background-disabled, ".concat(_colors.N20, ")"),
    backgroundColorUnchecked: "var(--ds-background-neutral-bold, ".concat(_colors.N200, ")"),
    backgroundColorUncheckedHover: "var(--ds-background-neutral-bold-hovered, ".concat(_colors.N400, ")"),
    backgroundColorUncheckedDisabled: "var(--ds-background-disabled, ".concat(_colors.N20, ")"),
    borderColorFocus: "var(--ds-border-focused, ".concat(_colors.B200, ")"),
    iconColorChecked: "var(--ds-icon-inverse, ".concat(_colors.N0, ")"),
    iconColorDisabled: "var(--ds-icon-disabled, ".concat(_colors.N70, ")"),
    iconColorUnchecked: "var(--ds-icon-inverse, ".concat(_colors.N0, ")"),
    handleBackgroundColor: "var(--ds-icon-inverse, ".concat(_colors.N0, ")"),
    handleBackgroundColorChecked: "var(--ds-icon-inverse, ".concat(_colors.N0, ")"),
    handleBackgroundColorDisabled: "var(--ds-icon-inverse, ".concat(_colors.N0, ")")
  },
  dark: {
    backgroundColorChecked: "var(--ds-background-success-bold, ".concat(_colors.G300, ")"),
    backgroundColorCheckedHover: "var(--ds-background-success-bold-hovered, ".concat(_colors.G200, ")"),
    backgroundColorCheckedDisabled: "var(--ds-background-disabled, ".concat(_colors.DN70, ")"),
    backgroundColorUnchecked: "var(--ds-background-neutral-bold, ".concat(_colors.DN70, ")"),
    backgroundColorUncheckedHover: "var(--ds-background-neutral-bold-hovered, ".concat(_colors.DN400, ")"),
    backgroundColorUncheckedDisabled: "var(--ds-background-disabled, ".concat(_colors.DN70, ")"),
    borderColorFocus: "var(--ds-border-focused, ".concat(_colors.B100, ")"),
    iconColorChecked: "var(--ds-icon-inverse, ".concat(_colors.DN30, ")"),
    iconColorDisabled: "var(--ds-icon-disabled, ".concat(_colors.DN30, ")"),
    iconColorUnchecked: "var(--ds-icon-inverse, ".concat(_colors.DN600, ")"),
    handleBackgroundColor: "var(--ds-icon-inverse, ".concat(_colors.DN600, ")"),
    handleBackgroundColorChecked: "var(--ds-icon-inverse, ".concat(_colors.DN0, ")"),
    handleBackgroundColorDisabled: "var(--ds-icon-inverse, ".concat(_colors.DN0, ")")
  }
};
var getColors = function getColors(mode) {
  return colorMap[mode];
};
exports.getColors = getColors;