"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getStyles = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = require("@emotion/react");
var _constants = require("@atlaskit/theme/constants");
var _colors = require("./colors");
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { (0, _defineProperty2.default)(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; } /* eslint-disable @atlaskit/design-system/ensure-design-token-usage */ // eslint-disable-next-line @atlaskit/design-system/no-deprecated-imports
var globalGridSize = (0, _constants.gridSize)();
var dimensions = {
  regular: {
    height: globalGridSize * 2,
    width: globalGridSize * 4
  },
  large: {
    height: globalGridSize * 2 + globalGridSize / 2,
    width: globalGridSize * 5
  }
};
var getHeight = function getHeight(_ref) {
  var size = _ref.size;
  return dimensions[size].height;
};
var getWidth = function getWidth(_ref2) {
  var size = _ref2.size;
  return dimensions[size].width;
};
var borderWidth = 2;
var paddingUnitless = globalGridSize / 4;
var transition = 'transform 0.2s ease';
var getStyles = function getStyles(size, mode) {
  var colors = (0, _colors.getColors)(mode);

  // TODO: Use tokens and reorganize to alphasemantic ordering (DSP-11769 DSP-11770)
  /* eslint-disable @atlaskit/design-system/ensure-design-token-usage/preview,@repo/internal/styles/consistent-style-ordering */
  return (0, _react.css)(_objectSpread(_objectSpread({
    boxSizing: 'content-box',
    display: 'inline-block',
    padding: borderWidth,
    margin: borderWidth,
    backgroundClip: 'content-box',
    backgroundColor: colors.backgroundColorUnchecked,
    borderRadius: "".concat(getHeight({
      size: size
    }), "px"),
    border: "".concat(borderWidth, "px solid transparent"),
    height: "".concat(getHeight({
      size: size
    }), "px"),
    position: 'relative',
    transition: "".concat(transition),
    width: "".concat(getWidth({
      size: size
    }), "px"),
    '&[data-checked]': {
      backgroundColor: colors.backgroundColorChecked,
      color: colors.iconColorChecked
    },
    '&[data-disabled]:not([data-checked])': {
      backgroundColor: colors.backgroundColorUncheckedDisabled
    },
    '&[data-disabled][data-checked],&[data-disabled][data-checked]:hover': {
      backgroundColor: colors.backgroundColorCheckedDisabled
    },
    '&:focus-within': {
      border: "".concat(borderWidth, "px solid ").concat(colors.borderColorFocus)
    },
    '&:hover': {
      backgroundColor: colors.backgroundColorUncheckedHover,
      cursor: 'pointer'
    },
    '&[data-disabled]:hover,&[data-disabled][data-checked]:hover,&[data-disabled]:not([data-checked]):hover': {
      cursor: 'not-allowed'
    },
    '&[data-checked]:hover': {
      backgroundColor: colors.backgroundColorCheckedHover
    },
    '&:not([data-checked]):hover': {
      backgroundColor: colors.backgroundColorUncheckedHover
    },
    '&[data-disabled]:not([data-checked]):hover': {
      backgroundColor: colors.backgroundColorCheckedDisabled
    },
    color: colors.iconColorUnchecked,
    '&[data-disabled], &[data-disabled][data-checked], &[data-disabled][data-checked]:hover': {
      color: colors.iconColorDisabled
    },
    // the input element underneath
    'input[type="checkbox"]': {
      opacity: 0,
      margin: 0,
      padding: 0,
      border: 'none',
      '&:focus': {
        outline: 'none !important'
      }
    },
    // slider
    '::before': {
      backgroundColor: colors.handleBackgroundColor,
      borderRadius: "var(--ds-border-radius-circle, 50%)",
      content: '""',
      position: 'absolute',
      transform: 'initial',
      transition: transition,
      bottom: "".concat(2 * paddingUnitless, "px"),
      height: "".concat(getHeight({
        size: size
      }) - paddingUnitless * 2, "px"),
      width: "".concat(getHeight({
        size: size
      }) - paddingUnitless * 2, "px"),
      // initially we set left as left-most position
      left: "".concat(2 * paddingUnitless, "px")
    },
    '&[data-checked]::before': {
      backgroundColor: colors.handleBackgroundColorChecked,
      // when  it's checked, slide the pseudo-element to right-most postion
      transform: "translateX(".concat(getHeight({
        size: size
      }), "px)")
    },
    '&[data-disabled]::before': {
      backgroundColor: colors.handleBackgroundColorDisabled,
      zIndex: 1
    },
    // icons - check and cross
    '> span': {
      position: 'absolute',
      top: "".concat(paddingUnitless, "px")
    },
    '>span:first-of-type': {
      left: "3px"
    },
    '>span:last-of-type': {
      right: "3px"
    }
  }, size === 'large' && {
    '> span': {
      position: 'absolute',
      height: '20px',
      width: '20px'
    }
  }), {}, {
    '@media screen and (forced-colors: active)': {
      '::before': {
        filter: 'grayscale(100%) invert(1)'
      },
      '&:focus-within': {
        outline: '1px solid'
      }
    }
  }));
};
exports.getStyles = getStyles;