"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getIconSize = exports.default = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));
var _react = require("react");
var _react2 = require("@emotion/react");
var _analyticsNext = require("@atlaskit/analytics-next");
var _noop = _interopRequireDefault(require("@atlaskit/ds-lib/noop"));
var _close = _interopRequireDefault(require("@atlaskit/icon/glyph/editor/close"));
var _done = _interopRequireDefault(require("@atlaskit/icon/glyph/editor/done"));
var _components = require("@atlaskit/theme/components");
var _styles = require("./internal/styles");
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { (0, _defineProperty2.default)(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; } /** @jsx jsx */
var getIconSize = function getIconSize(size) {
  return size === 'large' ? 'large' : 'small';
};
exports.getIconSize = getIconSize;
var noop = _noop.default;
var analyticsAttributes = {
  componentName: 'toggle',
  packageName: "@atlaskit/toggle",
  packageVersion: "12.6.9"
};

/**
 * __Toggle__
 *
 * A toggle is used to view or switch between enabled or disabled states.
 *
 * - [Examples](https://atlassian.design/components/toggle/examples)
 * - [Code](https://atlassian.design/components/toggle/code)
 * - [Usage](https://atlassian.design/components/toggle/usage)
 */
var Toggle = /*#__PURE__*/(0, _react.memo)( /*#__PURE__*/(0, _react.forwardRef)(function (props, ref) {
  var _props$defaultChecked = props.defaultChecked,
    defaultChecked = _props$defaultChecked === void 0 ? false : _props$defaultChecked,
    _props$isDisabled = props.isDisabled,
    isDisabled = _props$isDisabled === void 0 ? false : _props$isDisabled,
    _props$onBlur = props.onBlur,
    providedOnBlur = _props$onBlur === void 0 ? noop : _props$onBlur,
    _props$onChange = props.onChange,
    providedChange = _props$onChange === void 0 ? noop : _props$onChange,
    _props$onFocus = props.onFocus,
    providedFocus = _props$onFocus === void 0 ? noop : _props$onFocus,
    _props$size = props.size,
    size = _props$size === void 0 ? 'regular' : _props$size,
    _props$name = props.name,
    name = _props$name === void 0 ? '' : _props$name,
    _props$value = props.value,
    value = _props$value === void 0 ? '' : _props$value,
    isChecked = props.isChecked,
    analyticsContext = props.analyticsContext,
    id = props.id,
    testId = props.testId,
    label = props.label;
  var _useGlobalTheme = (0, _components.useGlobalTheme)(),
    mode = _useGlobalTheme.mode;
  var isControlled = typeof isChecked === 'undefined';
  var _useState = (0, _react.useState)(defaultChecked),
    _useState2 = (0, _slicedToArray2.default)(_useState, 2),
    checked = _useState2[0],
    setChecked = _useState2[1];
  var handleBlur = (0, _analyticsNext.usePlatformLeafEventHandler)(_objectSpread({
    fn: providedOnBlur,
    action: 'blur',
    analyticsData: analyticsContext
  }, analyticsAttributes));
  var handleFocus = (0, _analyticsNext.usePlatformLeafEventHandler)(_objectSpread({
    fn: providedFocus,
    action: 'focus',
    analyticsData: analyticsContext
  }, analyticsAttributes));
  var handleChange = (0, _analyticsNext.usePlatformLeafEventHandler)(_objectSpread({
    fn: function fn(event, analyticsEvent) {
      if (isControlled) {
        setChecked(function (checked) {
          return !checked;
        });
      }
      return providedChange(event, analyticsEvent);
    },
    action: 'change',
    analyticsData: analyticsContext
  }, analyticsAttributes));
  var shouldChecked = isControlled ? checked : isChecked;
  var controlProps = {
    'data-checked': shouldChecked ? shouldChecked : undefined,
    'data-disabled': isDisabled ? isDisabled : undefined,
    'data-size': size,
    'data-testid': testId ? testId : undefined
  };
  var toggleStyles = (0, _react.useMemo)(function () {
    return (0, _styles.getStyles)(size, mode);
  }, [size, mode]);
  return (0, _react2.jsx)("label", (0, _extends2.default)({}, controlProps, {
    css: toggleStyles
  }), (0, _react2.jsx)("input", {
    ref: ref,
    checked: shouldChecked,
    disabled: isDisabled,
    id: id,
    name: name,
    onBlur: handleBlur,
    onChange: handleChange,
    onFocus: handleFocus,
    type: "checkbox",
    value: value,
    "data-testid": testId && "".concat(testId, "--input"),
    "aria-label": label
  }), (0, _react2.jsx)(_done.default, {
    label: "",
    size: getIconSize(size),
    testId: testId && "".concat(testId, "--toggle-check-icon")
  }), (0, _react2.jsx)(_close.default, {
    label: "",
    size: getIconSize(size),
    testId: testId && "".concat(testId, "--toggle-cross-icon")
  }));
}));
Toggle.displayName = 'Toggle';
var _default = Toggle;
exports.default = _default;