import { B100, B200, DN0, DN30, DN400, DN600, DN70, G200, G300, G400, G500, N0, N20, N200, N400, N70 } from '@atlaskit/theme/colors';
const colorMap = {
  light: {
    backgroundColorChecked: `var(--ds-background-success-bold, ${G400})`,
    backgroundColorCheckedHover: `var(--ds-background-success-bold-hovered, ${G500})`,
    backgroundColorCheckedDisabled: `var(--ds-background-disabled, ${N20})`,
    backgroundColorUnchecked: `var(--ds-background-neutral-bold, ${N200})`,
    backgroundColorUncheckedHover: `var(--ds-background-neutral-bold-hovered, ${N400})`,
    backgroundColorUncheckedDisabled: `var(--ds-background-disabled, ${N20})`,
    borderColorFocus: `var(--ds-border-focused, ${B200})`,
    iconColorChecked: `var(--ds-icon-inverse, ${N0})`,
    iconColorDisabled: `var(--ds-icon-disabled, ${N70})`,
    iconColorUnchecked: `var(--ds-icon-inverse, ${N0})`,
    handleBackgroundColor: `var(--ds-icon-inverse, ${N0})`,
    handleBackgroundColorChecked: `var(--ds-icon-inverse, ${N0})`,
    handleBackgroundColorDisabled: `var(--ds-icon-inverse, ${N0})`
  },
  dark: {
    backgroundColorChecked: `var(--ds-background-success-bold, ${G300})`,
    backgroundColorCheckedHover: `var(--ds-background-success-bold-hovered, ${G200})`,
    backgroundColorCheckedDisabled: `var(--ds-background-disabled, ${DN70})`,
    backgroundColorUnchecked: `var(--ds-background-neutral-bold, ${DN70})`,
    backgroundColorUncheckedHover: `var(--ds-background-neutral-bold-hovered, ${DN400})`,
    backgroundColorUncheckedDisabled: `var(--ds-background-disabled, ${DN70})`,
    borderColorFocus: `var(--ds-border-focused, ${B100})`,
    iconColorChecked: `var(--ds-icon-inverse, ${DN30})`,
    iconColorDisabled: `var(--ds-icon-disabled, ${DN30})`,
    iconColorUnchecked: `var(--ds-icon-inverse, ${DN600})`,
    handleBackgroundColor: `var(--ds-icon-inverse, ${DN600})`,
    handleBackgroundColorChecked: `var(--ds-icon-inverse, ${DN0})`,
    handleBackgroundColorDisabled: `var(--ds-icon-inverse, ${DN0})`
  }
};
export const getColors = mode => {
  return colorMap[mode];
};