import { B100, B200, DN0, DN30, DN400, DN600, DN70, G200, G300, G400, G500, N0, N20, N200, N400, N70 } from '@atlaskit/theme/colors';
var colorMap = {
  light: {
    backgroundColorChecked: "var(--ds-background-success-bold, ".concat(G400, ")"),
    backgroundColorCheckedHover: "var(--ds-background-success-bold-hovered, ".concat(G500, ")"),
    backgroundColorCheckedDisabled: "var(--ds-background-disabled, ".concat(N20, ")"),
    backgroundColorUnchecked: "var(--ds-background-neutral-bold, ".concat(N200, ")"),
    backgroundColorUncheckedHover: "var(--ds-background-neutral-bold-hovered, ".concat(N400, ")"),
    backgroundColorUncheckedDisabled: "var(--ds-background-disabled, ".concat(N20, ")"),
    borderColorFocus: "var(--ds-border-focused, ".concat(B200, ")"),
    iconColorChecked: "var(--ds-icon-inverse, ".concat(N0, ")"),
    iconColorDisabled: "var(--ds-icon-disabled, ".concat(N70, ")"),
    iconColorUnchecked: "var(--ds-icon-inverse, ".concat(N0, ")"),
    handleBackgroundColor: "var(--ds-icon-inverse, ".concat(N0, ")"),
    handleBackgroundColorChecked: "var(--ds-icon-inverse, ".concat(N0, ")"),
    handleBackgroundColorDisabled: "var(--ds-icon-inverse, ".concat(N0, ")")
  },
  dark: {
    backgroundColorChecked: "var(--ds-background-success-bold, ".concat(G300, ")"),
    backgroundColorCheckedHover: "var(--ds-background-success-bold-hovered, ".concat(G200, ")"),
    backgroundColorCheckedDisabled: "var(--ds-background-disabled, ".concat(DN70, ")"),
    backgroundColorUnchecked: "var(--ds-background-neutral-bold, ".concat(DN70, ")"),
    backgroundColorUncheckedHover: "var(--ds-background-neutral-bold-hovered, ".concat(DN400, ")"),
    backgroundColorUncheckedDisabled: "var(--ds-background-disabled, ".concat(DN70, ")"),
    borderColorFocus: "var(--ds-border-focused, ".concat(B100, ")"),
    iconColorChecked: "var(--ds-icon-inverse, ".concat(DN30, ")"),
    iconColorDisabled: "var(--ds-icon-disabled, ".concat(DN30, ")"),
    iconColorUnchecked: "var(--ds-icon-inverse, ".concat(DN600, ")"),
    handleBackgroundColor: "var(--ds-icon-inverse, ".concat(DN600, ")"),
    handleBackgroundColorChecked: "var(--ds-icon-inverse, ".concat(DN0, ")"),
    handleBackgroundColorDisabled: "var(--ds-icon-inverse, ".concat(DN0, ")")
  }
};
export var getColors = function getColors(mode) {
  return colorMap[mode];
};