/// <reference types="react" />
import { Size, ToggleProps } from './types';
export declare const getIconSize: (size: Size) => "large" | "small";
/**
 * __Toggle__
 *
 * A toggle is used to view or switch between enabled or disabled states.
 *
 * - [Examples](https://atlassian.design/components/toggle/examples)
 * - [Code](https://atlassian.design/components/toggle/code)
 * - [Usage](https://atlassian.design/components/toggle/usage)
 */
declare const Toggle: import("react").MemoExoticComponent<import("react").ForwardRefExoticComponent<Pick<ToggleProps, "isDisabled" | "id" | "name" | "value" | "onBlur" | "onChange" | "onFocus" | "size" | "testId" | "analyticsContext" | "defaultChecked" | "isChecked" | "label" | "createAnalyticsEvent"> & import("react").RefAttributes<HTMLInputElement>>>;
export default Toggle;
