"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getGlobalTheme = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _constants = require("./constants");
var _themeConfig = require("./theme-config");
var _themeStateTransformer = require("./utils/theme-state-transformer");
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { (0, _defineProperty2.default)(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }
var isThemeColorMode = function isThemeColorMode(colorMode) {
  return _themeConfig.themeColorModes.find(function (mode) {
    return mode === colorMode;
  }) !== undefined;
};
var getGlobalTheme = function getGlobalTheme() {
  if (typeof document === 'undefined') {
    return {};
  }
  var element = document.documentElement;
  var colorMode = element.getAttribute(_constants.COLOR_MODE_ATTRIBUTE) || '';
  var theme = element.getAttribute(_constants.THEME_DATA_ATTRIBUTE) || '';
  return _objectSpread(_objectSpread({}, (0, _themeStateTransformer.themeStringToObject)(theme)), isThemeColorMode(colorMode) && {
    colorMode: colorMode
  });
};
exports.getGlobalTheme = getGlobalTheme;