"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ThemeMutationObserver = void 0;
var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));
var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _constants = require("./constants");
var _getGlobalTheme = require("./get-global-theme");
/**
 * A MutationObserver which watches the `<html>` element for changes to the theme.
 *
 * In React, use the {@link useThemeObserver `useThemeObserver`} hook instead.
 *
 * @param {function} callback - A callback function which fires when the theme changes.
 *
 * @example
 * ```
 * const observer = new ThemeMutationObserver((theme) => {});
 * observer.observe();
 * ```
 */
var ThemeMutationObserver = /*#__PURE__*/function () {
  function ThemeMutationObserver(callback) {
    (0, _classCallCheck2.default)(this, ThemeMutationObserver);
    (0, _defineProperty2.default)(this, "observer", null);
    (0, _defineProperty2.default)(this, "mediaObserver", null);
    this.callback = callback;
  }
  (0, _createClass2.default)(ThemeMutationObserver, [{
    key: "observe",
    value: function observe() {
      var _this = this;
      if (!this.observer) {
        this.observer = new MutationObserver(function () {
          _this.callback((0, _getGlobalTheme.getGlobalTheme)());
        });
      }
      this.observer.observe(document.documentElement, {
        attributeFilter: [_constants.THEME_DATA_ATTRIBUTE, _constants.COLOR_MODE_ATTRIBUTE]
      });
    }
  }, {
    key: "disconnect",
    value: function disconnect() {
      this.observer && this.observer.disconnect();
    }
  }]);
  return ThemeMutationObserver;
}();
exports.ThemeMutationObserver = ThemeMutationObserver;