import themeImportMap from '../artifacts/theme-import-map';
import { CUSTOM_THEME_ATTRIBUTE, THEME_DATA_ATTRIBUTE } from '../constants';
export const loadAndAppendThemeCss = async themeId => {
  if (document.head.querySelector(`style[${THEME_DATA_ATTRIBUTE}="${themeId}"]:not([${CUSTOM_THEME_ATTRIBUTE}])`)) {
    return;
  }
  const themeCss = await loadThemeCss(themeId);
  const style = document.createElement('style');
  style.textContent = themeCss;
  style.dataset.theme = themeId;
  document.head.appendChild(style);
};
export const loadThemeCss = async themeId => {
  const {
    default: themeCss
  } = await themeImportMap[themeId]();
  return themeCss;
};