import _defineProperty from "@babel/runtime/helpers/defineProperty";
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }
import { COLOR_MODE_ATTRIBUTE, THEME_DATA_ATTRIBUTE } from './constants';
import { themeColorModes } from './theme-config';
import { themeStringToObject } from './utils/theme-state-transformer';
var isThemeColorMode = function isThemeColorMode(colorMode) {
  return themeColorModes.find(function (mode) {
    return mode === colorMode;
  }) !== undefined;
};
export var getGlobalTheme = function getGlobalTheme() {
  if (typeof document === 'undefined') {
    return {};
  }
  var element = document.documentElement;
  var colorMode = element.getAttribute(COLOR_MODE_ATTRIBUTE) || '';
  var theme = element.getAttribute(THEME_DATA_ATTRIBUTE) || '';
  return _objectSpread(_objectSpread({}, themeStringToObject(theme)), isThemeColorMode(colorMode) && {
    colorMode: colorMode
  });
};