import _classCallCheck from "@babel/runtime/helpers/classCallCheck";
import _createClass from "@babel/runtime/helpers/createClass";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
import { COLOR_MODE_ATTRIBUTE, THEME_DATA_ATTRIBUTE } from './constants';
import { getGlobalTheme } from './get-global-theme';
/**
 * A MutationObserver which watches the `<html>` element for changes to the theme.
 *
 * In React, use the {@link useThemeObserver `useThemeObserver`} hook instead.
 *
 * @param {function} callback - A callback function which fires when the theme changes.
 *
 * @example
 * ```
 * const observer = new ThemeMutationObserver((theme) => {});
 * observer.observe();
 * ```
 */
export var ThemeMutationObserver = /*#__PURE__*/function () {
  function ThemeMutationObserver(callback) {
    _classCallCheck(this, ThemeMutationObserver);
    _defineProperty(this, "observer", null);
    _defineProperty(this, "mediaObserver", null);
    this.callback = callback;
  }
  _createClass(ThemeMutationObserver, [{
    key: "observe",
    value: function observe() {
      var _this = this;
      if (!this.observer) {
        this.observer = new MutationObserver(function () {
          _this.callback(getGlobalTheme());
        });
      }
      this.observer.observe(document.documentElement, {
        attributeFilter: [THEME_DATA_ATTRIBUTE, COLOR_MODE_ATTRIBUTE]
      });
    }
  }, {
    key: "disconnect",
    value: function disconnect() {
      this.observer && this.observer.disconnect();
    }
  }]);
  return ThemeMutationObserver;
}();