import { FontFamilyPaletteTokenSchema, FontSizeScaleTokenSchema, FontWeightScaleTokenSchema, LineHeightScaleTokenSchema } from '../types';
export type FontSizeScaleValues = 'FontSize050' | 'FontSize075' | 'FontSize100' | 'FontSize200' | 'FontSize300' | 'FontSize400' | 'FontSize500' | 'FontSize600';
export type LineHeightScaleValues = 'LineHeight100' | 'LineHeight200' | 'LineHeight300' | 'LineHeight400' | 'LineHeight500' | 'LineHeight600';
export type FontWeightScaleValues = 'FontWeightRegular' | 'FontWeightMedium' | 'FontWeightSemiBold' | 'FontWeightBold';
export type FontFamilyPaletteValues = 'FontFamilySans' | 'FontFamilyMonospace';
export type AtlassianTokenSchema = {
    typography: FontSizeScaleTokenSchema<FontSizeScaleValues> | FontWeightScaleTokenSchema<FontWeightScaleValues> | FontFamilyPaletteTokenSchema<FontFamilyPaletteValues> | LineHeightScaleTokenSchema<LineHeightScaleValues>;
};
export type LineHeightBaseToken = keyof LineHeightScaleTokenSchema<LineHeightScaleValues>['lineHeight'];
export type FontWeightBaseToken = keyof FontWeightScaleTokenSchema<FontWeightScaleValues>['fontWeight'];
export type FontFamilyBaseToken = keyof FontFamilyPaletteTokenSchema<FontFamilyPaletteValues>['fontFamily'];
export type FontSizeBaseToken = keyof FontSizeScaleTokenSchema<FontSizeScaleValues>['fontSize'];
declare const typographyPalette: AtlassianTokenSchema;
export default typographyPalette;
