import { ActiveThemeState } from './set-global-theme';
/**
 * A MutationObserver which watches the `<html>` element for changes to the theme.
 *
 * In React, use the {@link useThemeObserver `useThemeObserver`} hook instead.
 *
 * @param {function} callback - A callback function which fires when the theme changes.
 *
 * @example
 * ```
 * const observer = new ThemeMutationObserver((theme) => {});
 * observer.observe();
 * ```
 */
export declare class ThemeMutationObserver {
    private callback;
    observer: MutationObserver | null;
    mediaObserver: any;
    constructor(callback: (theme: Partial<ActiveThemeState>) => unknown);
    observe(): void;
    disconnect(): void;
}
