import _toConsumableArray from "@babel/runtime/helpers/toConsumableArray";
import { getBooleanFF } from '@atlaskit/platform-feature-flags';
import getIncreasedContrastTheme from './get-increased-contrast-theme';
export var getThemePreferences = function getThemePreferences(themeState) {
  var colorMode = themeState.colorMode,
    contrastMode = themeState.contrastMode,
    dark = themeState.dark,
    light = themeState.light,
    shape = themeState.shape,
    spacing = themeState.spacing,
    typography = themeState.typography;
  var autoColorModeThemes = [light, dark];
  var themePreferences = [];
  if (colorMode === 'auto') {
    if (contrastMode !== 'no-preference' && getBooleanFF('platform.design-system-team.increased-contrast-themes')) {
      autoColorModeThemes.forEach(function (normalTheme) {
        var increasedContrastTheme = getIncreasedContrastTheme(normalTheme);
        if (increasedContrastTheme) {
          autoColorModeThemes.push(increasedContrastTheme);
        }
      });
    }
    themePreferences.push.apply(themePreferences, autoColorModeThemes);
  } else {
    themePreferences.push(themeState[colorMode]);
    if (contrastMode !== 'no-preference' && getBooleanFF('platform.design-system-team.increased-contrast-themes')) {
      var increasedContrastTheme = getIncreasedContrastTheme(themeState[colorMode]);
      if (increasedContrastTheme) {
        themePreferences.push(increasedContrastTheme);
      }
    }
  }
  [shape, spacing, typography].forEach(function (themeId) {
    if (themeId) {
      themePreferences.push(themeId);
    }
  });
  return _toConsumableArray(new Set(themePreferences));
};
export var getThemeOverridePreferences = function getThemeOverridePreferences(themeState) {
  var colorMode = themeState.colorMode,
    dark = themeState.dark,
    light = themeState.light;
  var themeOverridePreferences = [];
  var themePreferences = colorMode === 'auto' ? [light, dark] : [themeState[colorMode]];
  if (getBooleanFF('platform.design-system-team.border-checkbox_nyoiu')) {
    themePreferences.includes('light') && themeOverridePreferences.push('light-new-input-border');
    themePreferences.includes('dark') && themeOverridePreferences.push('dark-new-input-border');
  }
  return _toConsumableArray(new Set(themeOverridePreferences));
};