import { ThemeState } from './theme-config';
/**
 * Converts a string that is formatted for the `data-theme` HTML attribute
 * to an object that can be passed to `setGlobalTheme`.
 *
 * @param {string} themes The themes that should be applied.
 *
 * @example
 * ```
 * themeStringToObject('dark:dark light:legacy-light spacing:spacing');
 * // returns { dark: 'dark', light: 'legacy-light', spacing: 'spacing' }
 * ```
 */
export declare const themeStringToObject: (themeState: string) => Partial<ThemeState>;
/**
 * Converts a theme object to a string formatted for the `data-theme` HTML attribute.
 *
 * @param {object} themes The themes that should be applied.
 *
 * @example
 * ```
 * themeObjectToString({ dark: 'dark', light: 'legacy-light', spacing: 'spacing' });
 * // returns 'dark:dark light:legacy-light spacing:spacing'
 * ```
 */
export declare const themeObjectToString: (themeState: Partial<ThemeState>) => string;
