export const legacyColors = [
  'R50',
  'R75',
  'R100',
  'R200',
  'R300',
  'R400',
  'R500',
  'Y50',
  'Y75',
  'Y100',
  'Y200',
  'Y300',
  'Y400',
  'Y500',
  'G50',
  'G75',
  'G100',
  'G200',
  'G300',
  'G400',
  'G500',
  'B50',
  'B75',
  'B100',
  'B200',
  'B300',
  'B400',
  'B500',
  'P50',
  'P75',
  'P100',
  'P200',
  'P300',
  'P400',
  'P500',
  'T50',
  'T75',
  'T100',
  'T200',
  'T300',
  'T400',
  'T500',
  'N0',
  'N10',
  'N20',
  'N30',
  'N40',
  'N50',
  'N60',
  'N70',
  'N80',
  'N90',
  'N100',
  'N200',
  'N300',
  'N400',
  'N500',
  'N600',
  'N700',
  'N800',
  'N900',
  'N10A',
  'N20A',
  'N30A',
  'N40A',
  'N50A',
  'N60A',
  'N70A',
  'N80A',
  'N90A',
  'N100A',
  'N200A',
  'N300A',
  'N400A',
  'N500A',
  'N600A',
  'N700A',
  'N800A',
  'DN900',
  'DN800',
  'DN700',
  'DN600',
  'DN500',
  'DN400',
  'DN300',
  'DN200',
  'DN100',
  'DN90',
  'DN80',
  'DN70',
  'DN60',
  'DN50',
  'DN40',
  'DN30',
  'DN20',
  'DN10',
  'DN0',
  'DN800A',
  'DN700A',
  'DN600A',
  'DN500A',
  'DN400A',
  'DN300A',
  'DN200A',
  'DN100A',
  'DN90A',
  'DN80A',
  'DN70A',
  'DN60A',
  'DN50A',
  'DN40A',
  'DN30A',
  'DN20A',
  'DN10A',
];

export const legacyColorMixins = [
  'background',
  'backgroundActive',
  'backgroundHover',
  'backgroundOnLayer',
  'text',
  'textHover',
  'textActive',
  'subtleText',
  'placeholderText',
  'heading',
  'subtleHeading',
  'codeBlock',
  'link',
  'linkHover',
  'linkActive',
  'linkOutline',
  'primary',
  'blue',
  'teal',
  'purple',
  'red',
  'yellow',
  'green',
  'skeleton',
];

export const legacyColorMetaMap: Record<string, string[]> = {
  R50: ['danger'],
  R75: ['danger'],
  R100: ['danger'],
  R200: ['danger'],
  R300: ['danger', 'bold'],
  R400: ['danger', 'bold'],
  R500: ['danger', 'bold'],
  Y50: ['warning'],
  Y75: ['warning'],
  Y100: ['warning'],
  Y200: ['warning'],
  Y300: ['warning', 'bold'],
  Y400: ['warning', 'bold'],
  Y500: ['warning', 'bold'],
  G50: ['success'],
  G75: ['success'],
  G100: ['success'],
  G200: ['success'],
  G300: ['success'],
  G400: ['success'],
  G500: ['success'],
  B50: ['information'],
  B75: ['information'],
  B100: ['information'],
  B200: ['information'],
  B300: ['information', 'bold'],
  B400: ['information', 'bold'],
  B500: ['information', 'bold'],
  P50: ['discovery'],
  P75: ['discovery'],
  P100: ['discovery'],
  P200: ['discovery'],
  P300: ['discovery', 'bold'],
  P400: ['discovery', 'bold'],
  P500: ['discovery', 'bold'],
  T50: ['accent', 'teal'],
  T75: ['accent', 'teal'],
  T100: ['accent', 'teal'],
  T200: ['accent', 'teal'],
  T300: ['accent', 'teal'],
  T400: ['accent', 'teal'],
  T500: ['accent', 'teal'],
  N0: ['inverse'],
  N10: ['neutral'],
  N20: ['neutral'],
  N30: ['neutral'],
  N40: ['neutral'],
  N50: ['neutral'],
  N60: ['neutral'],
  N70: ['neutral'],
  N80: ['neutral'],
  N90: ['neutral'],
  N100: ['neutral'],
  N200: ['neutral'],
  N300: ['neutral'],
  N400: ['neutral'],
  N500: ['neutral'],
  N600: ['neutral'],
  N700: ['neutral'],
  N800: ['neutral'],
  N900: ['neutral'],
  background: ['background', 'default'],
  backgroundActive: ['background', 'pressed'],
  backgroundHover: ['background', 'hovered'],
  backgroundOnLayer: ['background', 'blanket'],
  text: ['text'],
  textHover: ['text', 'subtle'],
  textActive: ['text', 'link', 'pressed'],
  subtleText: ['text', 'subtlest'],
  placeholderText: ['text', 'subtlest'],
  heading: ['text'],
  subtleHeading: ['text', 'subtle'],
  link: ['link'],
  linkHover: ['link', 'hovered'],
  linkActive: ['link', 'pressed'],
  linkOutline: ['border', 'selected'],
  primary: ['brand'],
  blue: ['accent', 'blue'],
  teal: ['accent', 'teal'],
  purple: ['accent', 'purple'],
  red: ['accent', 'red'],
  yellow: ['accent', 'orange'],
  green: ['accent', 'green'],
  grey: ['background', 'neutral'],
  skeleton: ['skeleton'],
  white: ['inverse'],
};
