import { ThemeStyles } from './get-theme-styles';
import { ThemeOptionsSchema, ThemeState } from './theme-config';
export declare const CUSTOM_STYLE_ELEMENTS_SIZE_THRESHOLD = 10;
/**
 *
 * @param themeSchema The schema of available themes
 * @returns a string with the CSS for the custom theme
 */
/**
 * Takes a color mode and custom branding options, and returns an array of objects for use in applying custom styles to the document head.
 * Only supplies the color themes necessary for initial render, based on the current themeState. I.e. if in light mode, dark mode themes are not returned.
 *
 * @param {Object<string, string>} themeState The themes and color mode that should be applied.
 * @param {string} themeState.colorMode Determines which color theme is applied
 * @param {Object} themeState.UNSAFE_themeOptions The custom branding options to be used for custom theme generation
 *
 * @returns An object array, containing theme IDs, data-attributes to attach to the theme, and the theme CSS.
 * If an error is encountered while loading themes, the themes array will be empty.
 */
export declare function getCustomThemeStyles(themeState: Partial<ThemeState> & {
    UNSAFE_themeOptions: ThemeOptionsSchema;
}): ThemeStyles[];
export declare function loadAndAppendCustomThemeCss(themeState: Partial<ThemeState> & {
    UNSAFE_themeOptions: ThemeOptionsSchema;
}): void;
