import { ThemeState } from './theme-config';
/**
 * Provides a script that, when executed before paint, sets the `data-color-mode` attribute based on the current system theme,
 * to enable SSR support for automatic theme switching, avoid a flash of un-themed content on first paint.
 *
 * @param {string} colorMode Determines which color theme is applied. If set to `auto`, the theme applied will be determined by the OS setting.
 *
 * @returns {string} A string to be added to the innerHTML of a script tag in the document head
 */
declare const getSSRAutoScript: (colorMode: ThemeState['colorMode'], contrastMode?: ThemeState['contrastMode']) => string | undefined;
export default getSSRAutoScript;
