import _typeof from "@babel/runtime/helpers/typeof";
import _slicedToArray from "@babel/runtime/helpers/slicedToArray";
import { themeIds } from './theme-config';
var themeKinds = ['light', 'dark', 'spacing', 'typography', 'shape'];
var customThemeOptions = 'UNSAFE_themeOptions';
var isThemeKind = function isThemeKind(themeKind) {
  return themeKinds.find(function (kind) {
    return kind === themeKind;
  }) !== undefined;
};
var isThemeIds = function isThemeIds(themeId) {
  return themeIds.find(function (id) {
    return id === themeId;
  }) !== undefined;
};
var isColorMode = function isColorMode(modeId) {
  return ['light', 'dark', 'auto'].includes(modeId);
};
/**
 * Converts a string that is formatted for the `data-theme` HTML attribute
 * to an object that can be passed to `setGlobalTheme`.
 *
 * @param {string} themes The themes that should be applied.
 *
 * @example
 * ```
 * themeStringToObject('dark:dark light:legacy-light spacing:spacing');
 * // returns { dark: 'dark', light: 'legacy-light', spacing: 'spacing' }
 * ```
 */
export var themeStringToObject = function themeStringToObject(themeState) {
  return themeState.split(' ').map(function (theme) {
    return theme.split(/:([\s\S]*)/);
  }).reduce(function (themeObject, _ref) {
    var _ref2 = _slicedToArray(_ref, 2),
      kind = _ref2[0],
      id = _ref2[1];
    if (kind === 'colorMode' && isColorMode(id)) {
      themeObject[kind] = id;
    }
    if (isThemeKind(kind) && isThemeIds(id)) {
      // @ts-expect-error FIXME - this is a valid ts error
      themeObject[kind] = id;
    }
    if (kind === customThemeOptions) {
      try {
        themeObject[customThemeOptions] = JSON.parse(id);
      } catch (e) {
        new Error('Invalid custom theme string');
      }
    }
    return themeObject;
  }, {});
};

/**
 * Converts a theme object to a string formatted for the `data-theme` HTML attribute.
 *
 * @param {object} themes The themes that should be applied.
 *
 * @example
 * ```
 * themeObjectToString({ dark: 'dark', light: 'legacy-light', spacing: 'spacing' });
 * // returns 'dark:dark light:legacy-light spacing:spacing'
 * ```
 */
export var themeObjectToString = function themeObjectToString(themeState) {
  return Object.entries(themeState).reduce(function (themeString, _ref3) {
    var _ref4 = _slicedToArray(_ref3, 2),
      kind = _ref4[0],
      id = _ref4[1];
    if (
    // colorMode theme state
    kind === 'colorMode' && typeof id === 'string' && isColorMode(id) ||
    // custom theme state
    kind === customThemeOptions && _typeof(id) === 'object' ||
    // other theme states
    isThemeKind(kind) && typeof id === 'string' && isThemeIds(id)) {
      return themeString + "".concat(themeString ? ' ' : '') + "".concat(kind, ":").concat(_typeof(id) === 'object' ? JSON.stringify(id) : id);
    }
    return themeString;
  }, '');
};