import _classCallCheck from "@babel/runtime/helpers/classCallCheck";
import _createClass from "@babel/runtime/helpers/createClass";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
import { bind as _bind } from 'bind-event-listener';
import { COLOR_MODE_ATTRIBUTE } from '../constants';
import { darkModeMediaQuery } from './theme-loading';
var isMatchMediaAvailable = typeof window !== 'undefined' && 'matchMedia' in window;

/**
 * Updates the current theme when the system theme changes. Should be bound
 * to an event listener listening on the '(prefers-color-scheme: dark)' query
 * @param e The event representing a change in system theme.
 */
function checkNativeListener(e) {
  var element = document.documentElement;
  element.setAttribute(COLOR_MODE_ATTRIBUTE, e.matches ? 'dark' : 'light');
}
var darkModeMql = isMatchMediaAvailable && window.matchMedia(darkModeMediaQuery);
var ColorModeObserver = /*#__PURE__*/function () {
  function ColorModeObserver() {
    _classCallCheck(this, ColorModeObserver);
    _defineProperty(this, "unbindThemeChangeListener", null);
  }
  _createClass(ColorModeObserver, [{
    key: "getColorMode",
    value: function getColorMode() {
      if (!darkModeMql) {
        return 'light';
      }
      return darkModeMql !== null && darkModeMql !== void 0 && darkModeMql.matches ? 'dark' : 'light';
    }
  }, {
    key: "bind",
    value: function bind() {
      if (darkModeMql && this.unbindThemeChangeListener === null) {
        this.unbindThemeChangeListener = _bind(darkModeMql, {
          type: 'change',
          listener: checkNativeListener
        });
      }
    }
  }, {
    key: "unbind",
    value: function unbind() {
      if (this.unbindThemeChangeListener) {
        this.unbindThemeChangeListener();
        this.unbindThemeChangeListener = null;
      }
    }
  }]);
  return ColorModeObserver;
}();
/**
 * A singleton color mode observer - binds "auto" switching logic to a single `mediaQueryList` listener
 * that can be unbound by any consumer when no longer needed.
 */
var SingletonColorModeObserver = new ColorModeObserver();
export default SingletonColorModeObserver;