import { type NodePath } from '@babel/traverse';
import * as t from '@babel/types';
type DefaultColorTheme = 'light' | 'legacy-light';
export default function plugin(): {
    visitor: {
        Program: {
            enter(path: NodePath<t.Program>, state: {
                opts: {
                    shouldUseAutoFallback?: boolean;
                    shouldForceAutoFallback?: boolean;
                    defaultTheme?: DefaultColorTheme;
                };
            }): void;
            exit(path: NodePath<t.Program>): void;
        };
    };
};
export {};
