"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = require("react");
var _react2 = require("@emotion/react");
var _colors = require("@atlaskit/theme/colors");
var _components = _interopRequireDefault(require("@atlaskit/theme/components"));
var _TooltipPrimitive = _interopRequireDefault(require("./TooltipPrimitive"));
/** @jsx jsx */

var baseStyles = (0, _react2.css)({
  boxSizing: 'border-box',
  maxWidth: '240px',
  padding: "var(--ds-space-025, 2px)".concat(" ", "var(--ds-space-075, 6px)"),
  top: "var(--ds-space-0, 0px)",
  left: "var(--ds-space-0, 0px)",
  borderRadius: "var(--ds-border-radius, 3px)",
  fontSize: "var(--ds-font-size-075, 12px)",
  lineHeight: 1.3,
  overflowWrap: 'break-word',
  wordWrap: 'break-word'
});
var truncateStyles = (0, _react2.css)({
  maxWidth: '420px',
  overflow: 'hidden',
  textOverflow: 'ellipsis',
  whiteSpace: 'nowrap'
});
var lightStyles = (0, _react2.css)({
  backgroundColor: "var(--ds-background-neutral-bold, ".concat(_colors.N800, ")"),
  color: "var(--ds-text-inverse, ".concat(_colors.N0, ")")
});
var darkStyles = (0, _react2.css)({
  backgroundColor: "var(--ds-background-neutral-bold, ".concat(_colors.DN0, ")"),
  color: "var(--ds-text-inverse, ".concat(_colors.DN600, ")")
});
var TooltipContainer = /*#__PURE__*/(0, _react.forwardRef)(function TooltipContainer(_ref, ref) {
  var style = _ref.style,
    className = _ref.className,
    children = _ref.children,
    truncate = _ref.truncate,
    placement = _ref.placement,
    testId = _ref.testId,
    onMouseOut = _ref.onMouseOut,
    onMouseOver = _ref.onMouseOver,
    id = _ref.id;
  return (0, _react2.jsx)(_components.default.Consumer, null, function (_ref2) {
    var mode = _ref2.mode;
    return (
      // eslint-disable-next-line jsx-a11y/mouse-events-have-key-events
      (0, _react2.jsx)(_TooltipPrimitive.default, {
        ref: ref,
        style: style,
        className: className,
        placement: placement,
        testId: testId,
        id: id,
        onMouseOut: onMouseOut,
        onMouseOver: onMouseOver,
        css: [baseStyles, truncate ? truncateStyles : null, mode === 'light' ? lightStyles : darkStyles]
      }, children)
    );
  });
});
TooltipContainer.displayName = 'TooltipContainer';
var _default = TooltipContainer;
exports.default = _default;