"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.clearScheduled = clearScheduled;
exports.scheduleTimeout = scheduleTimeout;
var delayId = null;
function clearScheduled() {
  if (delayId != null) {
    window.clearTimeout(delayId);
    delayId = null;
  }
}
function scheduleTimeout(fn, delay) {
  clearScheduled();
  delayId = window.setTimeout(function () {
    delayId = null;
    fn();
  }, delay);
}