/** @jsx jsx */
import { forwardRef } from 'react';
import { css, jsx } from '@emotion/react';
import { DN0, DN600, N0, N800 } from '@atlaskit/theme/colors';
import GlobalTheme from '@atlaskit/theme/components';
import TooltipPrimitive from './TooltipPrimitive';
const baseStyles = css({
  boxSizing: 'border-box',
  maxWidth: '240px',
  padding: `${"var(--ds-space-025, 2px)"} ${"var(--ds-space-075, 6px)"}`,
  top: "var(--ds-space-0, 0px)",
  left: "var(--ds-space-0, 0px)",
  borderRadius: "var(--ds-border-radius, 3px)",
  fontSize: "var(--ds-font-size-075, 12px)",
  lineHeight: 1.3,
  overflowWrap: 'break-word',
  wordWrap: 'break-word'
});
const truncateStyles = css({
  maxWidth: '420px',
  overflow: 'hidden',
  textOverflow: 'ellipsis',
  whiteSpace: 'nowrap'
});
const lightStyles = css({
  backgroundColor: `var(--ds-background-neutral-bold, ${N800})`,
  color: `var(--ds-text-inverse, ${N0})`
});
const darkStyles = css({
  backgroundColor: `var(--ds-background-neutral-bold, ${DN0})`,
  color: `var(--ds-text-inverse, ${DN600})`
});
const TooltipContainer = /*#__PURE__*/forwardRef(function TooltipContainer({
  style,
  className,
  children,
  truncate,
  placement,
  testId,
  onMouseOut,
  onMouseOver,
  id
}, ref) {
  return jsx(GlobalTheme.Consumer, null, ({
    mode
  }) =>
  // eslint-disable-next-line jsx-a11y/mouse-events-have-key-events
  jsx(TooltipPrimitive, {
    ref: ref,
    style: style,
    className: className,
    placement: placement,
    testId: testId,
    id: id,
    onMouseOut: onMouseOut,
    onMouseOver: onMouseOver,
    css: [baseStyles, truncate ? truncateStyles : null, mode === 'light' ? lightStyles : darkStyles]
  }, children));
});
TooltipContainer.displayName = 'TooltipContainer';
export default TooltipContainer;