/** @jsx jsx */
import { forwardRef } from 'react';
import { css, jsx } from '@emotion/react';
import { layers } from '@atlaskit/theme/constants';
const VAR_PRIMITIVE_ZINDEX = 'tooltipPrimitiveZindex';
const primitiveStyles = css({
  zindex: `var(${VAR_PRIMITIVE_ZINDEX})`,
  cursor: `default`
});
const TooltipPrimitive = /*#__PURE__*/forwardRef(function TooltipPrimitive({
  style,
  className,
  children,
  placement,
  testId,
  onMouseOut,
  onMouseOver,
  id
}, ref) {
  const styleWithZIndex = {
    ...style,
    [VAR_PRIMITIVE_ZINDEX]: layers.tooltip()
  };
  return jsx("div", {
    ref: ref,
    style: styleWithZIndex,
    "data-testid": testId ? `${testId}--wrapper` : undefined
  }, jsx("div", {
    role: "tooltip",
    className: className,
    onMouseOut: onMouseOut,
    onMouseOver: onMouseOver,
    css: primitiveStyles,
    "data-placement": placement,
    "data-testid": testId,
    id: id
  }, children));
});
TooltipPrimitive.displayName = 'TooltipPrimitive';
export default TooltipPrimitive;