/** @jsx jsx */
import { forwardRef } from 'react';
import { css, jsx } from '@emotion/react';
import { DN0, DN600, N0, N800 } from '@atlaskit/theme/colors';
import GlobalTheme from '@atlaskit/theme/components';
import TooltipPrimitive from './TooltipPrimitive';
var baseStyles = css({
  boxSizing: 'border-box',
  maxWidth: '240px',
  padding: "var(--ds-space-025, 2px)".concat(" ", "var(--ds-space-075, 6px)"),
  top: "var(--ds-space-0, 0px)",
  left: "var(--ds-space-0, 0px)",
  borderRadius: "var(--ds-border-radius, 3px)",
  fontSize: "var(--ds-font-size-075, 12px)",
  lineHeight: 1.3,
  overflowWrap: 'break-word',
  wordWrap: 'break-word'
});
var truncateStyles = css({
  maxWidth: '420px',
  overflow: 'hidden',
  textOverflow: 'ellipsis',
  whiteSpace: 'nowrap'
});
var lightStyles = css({
  backgroundColor: "var(--ds-background-neutral-bold, ".concat(N800, ")"),
  color: "var(--ds-text-inverse, ".concat(N0, ")")
});
var darkStyles = css({
  backgroundColor: "var(--ds-background-neutral-bold, ".concat(DN0, ")"),
  color: "var(--ds-text-inverse, ".concat(DN600, ")")
});
var TooltipContainer = /*#__PURE__*/forwardRef(function TooltipContainer(_ref, ref) {
  var style = _ref.style,
    className = _ref.className,
    children = _ref.children,
    truncate = _ref.truncate,
    placement = _ref.placement,
    testId = _ref.testId,
    onMouseOut = _ref.onMouseOut,
    onMouseOver = _ref.onMouseOver,
    id = _ref.id;
  return jsx(GlobalTheme.Consumer, null, function (_ref2) {
    var mode = _ref2.mode;
    return (
      // eslint-disable-next-line jsx-a11y/mouse-events-have-key-events
      jsx(TooltipPrimitive, {
        ref: ref,
        style: style,
        className: className,
        placement: placement,
        testId: testId,
        id: id,
        onMouseOut: onMouseOut,
        onMouseOver: onMouseOver,
        css: [baseStyles, truncate ? truncateStyles : null, mode === 'light' ? lightStyles : darkStyles]
      }, children)
    );
  });
});
TooltipContainer.displayName = 'TooltipContainer';
export default TooltipContainer;