import _defineProperty from "@babel/runtime/helpers/defineProperty";
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }
/** @jsx jsx */
import { forwardRef } from 'react';
import { css, jsx } from '@emotion/react';
import { layers } from '@atlaskit/theme/constants';
var VAR_PRIMITIVE_ZINDEX = 'tooltipPrimitiveZindex';
var primitiveStyles = css({
  zindex: "var(".concat(VAR_PRIMITIVE_ZINDEX, ")"),
  cursor: "default"
});
var TooltipPrimitive = /*#__PURE__*/forwardRef(function TooltipPrimitive(_ref, ref) {
  var style = _ref.style,
    className = _ref.className,
    children = _ref.children,
    placement = _ref.placement,
    testId = _ref.testId,
    onMouseOut = _ref.onMouseOut,
    onMouseOver = _ref.onMouseOver,
    id = _ref.id;
  var styleWithZIndex = _objectSpread(_objectSpread({}, style), {}, _defineProperty({}, VAR_PRIMITIVE_ZINDEX, layers.tooltip()));
  return jsx("div", {
    ref: ref,
    style: styleWithZIndex,
    "data-testid": testId ? "".concat(testId, "--wrapper") : undefined
  }, jsx("div", {
    role: "tooltip",
    className: className,
    onMouseOut: onMouseOut,
    onMouseOver: onMouseOver,
    css: primitiveStyles,
    "data-placement": placement,
    "data-testid": testId,
    id: id
  }, children));
});
TooltipPrimitive.displayName = 'TooltipPrimitive';
export default TooltipPrimitive;