import { FakeMouseElement } from '../utilities';
export type Source = {
    type: 'mouse';
    mouse: FakeMouseElement;
} | {
    type: 'keyboard';
};
export type Entry = {
    source: Source;
    show: (value: {
        isImmediate: boolean;
    }) => void;
    hide: (value: {
        isImmediate: boolean;
    }) => void;
    delay: number;
    done: () => void;
};
export type API = {
    isActive: () => boolean;
    mousePosition: FakeMouseElement | null;
    requestHide: (value: {
        isImmediate: boolean;
    }) => void;
    finishHideAnimation: () => void;
    keep: () => void;
    abort: () => void;
};
export declare function show(entry: Entry): API;
