/* global window */
function attrobj (key, el) {
  var values = {};
  Object.keys(el.dataset).forEach(function (data) {
    if (data.match(new RegExp("^" + key)) && data !== key) {
      var optionName = data.replace(key, '');
      var isGlobal = false;

      if (optionName.match(/^Global/)) {
        optionName = optionName.replace('Global', '');
        isGlobal = true;
      }

      optionName = "" + optionName[0].toLowerCase() + optionName.slice(1);

      if (isGlobal) {
        values[optionName] = window[el.dataset[data]];
      } else {
        values[optionName] = el.dataset[data];
      }

      if (typeof values[optionName] === 'undefined' || values[optionName] === '') {
        values[optionName] = true;
      }
    }
  });
  return values;
}

export default attrobj;
//# sourceMappingURL=attrobj.js.map
